package fr.ifremer.tutti.ui.swing.content.operation.catches.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id: PlanktonBatchTableModel.java 723 2013-04-03 18:25:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/plankton/PlanktonBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class PlanktonBatchTableModel extends AbstractTuttiTableModel<PlanktonBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<PlanktonBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_SPECIES_TO_CONFIRM,
            n_("tutti.editPlanktonBatch.table.header.toConfirm"),
            n_("tutti.editPlanktonBatch.table.header.toConfirm.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> SPECIES_BY_CODE = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editPlanktonBatch.table.header.speciesByCode"),
            n_("tutti.editPlanktonBatch.table.header.speciesByCode.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> SPECIES_BY_GENUS_CODE = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_SPECIES,
            n_("tutti.editPlanktonBatch.table.header.speciesByGenusCode"),
            n_("tutti.editPlanktonBatch.table.header.speciesByGenusCode.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.editPlanktonBatch.table.header.weight"),
            n_("tutti.editPlanktonBatch.table.header.weight.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> SAMPLE_WEIGHT = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_SAMPLE_WEIGHT,
            n_("tutti.editPlanktonBatch.table.header.sampleWeight"),
            n_("tutti.editPlanktonBatch.table.header.sampleWeight.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> COMMENT = ColumnIdentifier.newId(
            PlanktonBatchRowModel.PROPERTY_COMMENT,
            n_("tutti.editPlanktonBatch.table.header.comment"),
            n_("tutti.editPlanktonBatch.table.header.comment.tip"));

    public static final ColumnIdentifier<PlanktonBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId(
            PlanktonBatchRowModel.PROPERTY_ATTACHMENT,
            n_("tutti.editPlanktonBatch.table.header.file"),
            n_("tutti.editPlanktonBatch.table.header.file.tip"));

    public PlanktonBatchTableModel(TableColumnModelExt columnModel) {
        super(columnModel, true, true);
        setNoneEditableCols();
    }

    @Override
    public PlanktonBatchRowModel createNewRow() {
        PlanktonBatchRowModel result = new PlanktonBatchRowModel();

        // by default empty row is not valid
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue,
                           int rowIndex,
                           int columnIndex,
                           ColumnIdentifier<PlanktonBatchRowModel> propertyName,
                           PlanktonBatchRowModel entry) {
        super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);

        if (propertyName == SPECIES_BY_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex, SPECIES_BY_GENUS_CODE);

        } else if (propertyName == SPECIES_BY_GENUS_CODE) {

            // update also other columns
            fireTableCellUpdated(rowIndex, SPECIES_BY_CODE);
        }
    }

}