package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: SplitBenthosBatchTableModel.java 666 2013-03-23 18:20:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/split/SplitBenthosBatchTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * Table model of sample categories values.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SplitBenthosBatchTableModel
        extends AbstractTuttiTableModel<SplitBenthosBatchRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> SELECTED = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_VALID,
            n_("tutti.splitBenthosBatch.table.header.selected"),
            n_("tutti.splitBenthosBatch.table.header.selected"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> EDITABLE_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n_("tutti.splitBenthosBatch.table.header.category"),
            n_("tutti.splitBenthosBatch.table.header.category"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> READ_ONLY_CATEGORY_VALUE = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_CATEGORY_VALUE,
            n_("tutti.splitBenthosBatch.table.header.category"),
            n_("tutti.splitBenthosBatch.table.header.category"));

    public static final ColumnIdentifier<SplitBenthosBatchRowModel> WEIGHT = ColumnIdentifier.newId(
            SplitBenthosBatchRowModel.PROPERTY_WEIGHT,
            n_("tutti.splitBenthosBatch.table.header.weight"),
            n_("tutti.splitBenthosBatch.table.header.weight"));

    private final SplitBenthosBatchUIModel uiModel;

    public SplitBenthosBatchTableModel(TableColumnModelExt columnModel,
                                       SplitBenthosBatchUIModel uiModel,
                                       boolean createEmptyRowIsEmpty) {
        super(columnModel, createEmptyRowIsEmpty, createEmptyRowIsEmpty);
        this.uiModel = uiModel;
        setNoneEditableCols(READ_ONLY_CATEGORY_VALUE);
    }

    @Override
    public SplitBenthosBatchRowModel createNewRow() {
        SplitBenthosBatchRowModel result = new SplitBenthosBatchRowModel();
        result.setCategoryType(uiModel.getSelectedCategory());
        result.setValid(false);
        return result;
    }

}