/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import java.awt.event.ActionEvent;
import org.nuiton.i18n.I18n;

public class SaveCruiseAction
extends AbstractTuttiAction<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    private static final long serialVersionUID = 1L;

    public SaveCruiseAction(EditCruiseUIHandler handler) {
        super(handler, "saveCruise", "save", I18n._((String)"tutti.action.saveCruise", (Object[])new Object[0]), I18n._((String)"tutti.action.saveCruise.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiUIContext context = this.getContext();
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        Cruise bean = (Cruise)model.toBean();
        Cruise saved = TuttiEntities.isNew(bean) ? persistenceService.createCruise(bean) : persistenceService.saveCruise(bean);
        context.setProgramId(saved.getProgram().getId());
        context.setCruiseId(saved.getId());
        TuttiScreen nextScreen = event.getSource().getClass().isAssignableFrom(TuttiScreen.class) ? (TuttiScreen)((Object)event.getSource()) : TuttiScreen.SELECT_CRUISE;
        context.setScreen(nextScreen);
    }
}

