/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import fr.ifremer.tutti.ui.swing.util.TuttiComputedOrNotData;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;

public class TuttiComputedOrNotDataTableCell
extends DefaultTableCellRenderer {
    public static TableCellRenderer newRender(TableCellRenderer renderer, boolean useFloat, Integer decimalNumber, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellRenderer(renderer, useFloat, decimalNumber, computedDataColor);
    }

    public static TableCellEditor newEditor(Class type, boolean useSign, boolean useFloat, Integer decimalNumber, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellEditor(type, useSign, useFloat, decimalNumber, computedDataColor);
    }

    public static class TuttiComputedOrNotDataTableCellRenderer<E>
    implements TableCellRenderer {
        protected final TableCellRenderer delegate;
        protected Integer decimalNumber;
        protected Color computedDataColor;
        protected boolean useFloat;

        public TuttiComputedOrNotDataTableCellRenderer(TableCellRenderer delegate, boolean useFloat, Integer decimalNumber, Color computedDataColor) {
            this.delegate = delegate;
            this.useFloat = useFloat;
            this.decimalNumber = decimalNumber;
            this.computedDataColor = computedDataColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Font font;
            TuttiComputedOrNotData data = (TuttiComputedOrNotData)((Object)value);
            Object dataValue = data.getData();
            if (dataValue == null) {
                dataValue = data.getComputedData();
                font = TuttiUI.TEXTFIELD_COMPUTED_FONT;
                foreground = this.computedDataColor;
            } else {
                font = TuttiUI.TEXTFIELD_NORMAL_FONT;
                foreground = Color.BLACK;
            }
            String text = this.useFloat && this.decimalNumber != null && dataValue != null ? JAXXUtil.getStringValue((Object)String.format("%." + this.decimalNumber + "f", dataValue)) : JAXXUtil.getStringValue(dataValue);
            Component component = this.delegate.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            component.setFont(font);
            component.setForeground(foreground);
            return component;
        }
    }

    public static class TuttiComputedOrNotDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    AncestorListener {
        private static final long serialVersionUID = 1L;
        protected final TuttiComputedOrNotDataEditor numberEditor = new TuttiComputedOrNotDataEditor();
        protected TuttiComputedOrNotData data;

        public TuttiComputedOrNotDataTableCellEditor(Class type, boolean useSign, boolean useFloat, Integer decimalNumber, Color computedDataColor) {
            this.numberEditor.setComputedDataColor(computedDataColor);
            this.numberEditor.getTextField().setHorizontalAlignment(4);
            this.numberEditor.getTextField().addFocusListener(this);
            this.numberEditor.getTextField().addAncestorListener(this);
            this.numberEditor.getTextField().setBorder(new LineBorder(Color.GRAY, 2));
            this.numberEditor.setSelectAllTextOnError(true);
            this.numberEditor.setNumberPattern("\\d{0,6}|\\d{1,6}\\.\\d{0,3}");
            this.numberEditor.setModelType(type);
            this.numberEditor.setUseSign(useSign);
            this.numberEditor.setUseFloat(useFloat);
            this.numberEditor.setDecimalNumber(decimalNumber);
            this.numberEditor.init();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.data = (TuttiComputedOrNotData)((Object)value);
            this.numberEditor.setModel((Number)this.data.getData());
            if (this.data.getData() != null) {
                this.numberEditor.setModelText(String.valueOf(this.data.getData()));
            }
            return this.numberEditor;
        }

        public TuttiComputedOrNotDataEditor getNumberEditor() {
            return this.numberEditor;
        }

        public TuttiComputedOrNotData getCellEditorValue() {
            return this.data;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().requestFocus();
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().requestFocus();
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = super.stopCellEditing();
            if (result) {
                this.data.setData(this.numberEditor.getModel());
                this.numberEditor.setBean(null);
                this.data = null;
            }
            return result;
        }
    }
}

