/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.decorator.Decorator;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>> {
    protected final H handler;
    protected final String actionName;
    protected final String actionDescription;
    protected final String actionIcon;
    protected final boolean hideBody;
    protected Throwable error;

    protected abstract void doAction() throws Exception;

    protected AbstractTuttiAction(H handler, String actionIcon, String actionName, String actionDescription, boolean hideBody) {
        this.handler = handler;
        this.actionName = actionName;
        this.actionDescription = actionDescription;
        this.actionIcon = actionIcon;
        this.hideBody = hideBody;
    }

    protected boolean prepareAction() {
        return true;
    }

    protected void releaseAction() {
        this.error = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performAndReleaseAction() {
        try {
            this.performAction();
        }
        finally {
            this.releaseAction();
        }
    }

    protected void performAction() {
        try {
            this.doAction();
        }
        catch (Throwable e) {
            this.error = e;
            throw new TuttiExceptionHandler.TuttiActionException(this, e);
        }
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractTuttiUIHandler)this.handler).getModel());
    }

    public final UI getUI() {
        return ((AbstractTuttiUIHandler)this.handler).getUI();
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    protected String getActionName() {
        return this.actionName;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public String getActionIcon() {
        return this.actionIcon;
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiApplicationConfig getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        Decorator<O> decorator = ((AbstractTuttiUIHandler)this.handler).getDecorator(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.getDecorator(object.getClass(), null).toString(object);
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }
}

