/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolCaracteristicAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolCaracteristicAction.class);
    private File file;

    public ImportProtocolCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, "import", I18n._((String)"tutti.action.importProtocolCaracteristic", (Object[])new Object[0]), I18n._((String)"tutti.action.importProtocolCaracteristic.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolCaracteristicImportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolCaracteristicFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol caracteristic file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.importProtocolCaracteristic(this.file, protocol, model.getAllCaracteristic());
        ((EditProtocolUIHandler)this.handler).addDoubleListListeners();
        try {
            model.fromBean(protocol);
        }
        finally {
            ((EditProtocolUIHandler)this.handler).removeDoubleListListeners();
        }
        this.sendMessage(I18n._((String)"tutti.flash.information.caracteristic.imported.in.protocol", (Object[])new Object[]{this.file}));
    }
}

