/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUIModel;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;

public class TuttiActionUIHandler
extends AbstractTuttiUIHandler<TuttiActionUIModel, TuttiActionUI> {
    private static final Log log = LogFactory.getLog(TuttiActionUIHandler.class);
    protected PropertyChangeListener progressionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("message".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskActionLabel().setText((String)evt.getNewValue());
            } else if ("total".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskProgressBar().setMaximum((Integer)evt.getNewValue());
            } else if ("current".equals(propertyName)) {
                ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskProgressBar().setValue((Integer)evt.getNewValue());
            }
        }
    };

    public TuttiActionUIHandler(TuttiUIContext context, TuttiActionUI ui) {
        super(context, ui);
    }

    protected void hideAction() {
        ((TuttiActionUI)this.ui).setVisible(false);
    }

    protected void showAction(AbstractTuttiAction action) {
        ((TuttiActionUI)this.ui).getGlobalActionLabel().setText(I18n._((String)"tutti.message.action.running", (Object[])new Object[]{action.getActionDescription()}));
        ((TuttiActionUI)this.ui).pack();
        MainUI mainUI = this.getContext().getMainUI();
        if (mainUI != null) {
            int y;
            int x;
            JXTitledPanel component = mainUI.getBody();
            int width = component.getWidth();
            int height = component.getHeight();
            if (height == 0) {
                x = mainUI.getX() + 5;
                y = mainUI.getY() + 20;
            } else {
                x = mainUI.getX() + (mainUI.getWidth() - width);
                y = mainUI.getY() + (mainUI.getHeight() - height);
            }
            ((TuttiActionUI)this.ui).setLocation(x, y);
        }
        ((TuttiActionUI)this.ui).setVisible(true);
    }

    @Override
    public void beforeInitUI() {
        TuttiActionUIModel model = new TuttiActionUIModel();
        ((TuttiActionUI)this.ui).setContextValue(model);
        model.addPropertyChangeListener("action", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTuttiAction action = (AbstractTuttiAction)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Action to use: " + action));
                }
                if (action == null || action.isFailed()) {
                    TuttiActionUIHandler.this.hideAction();
                } else {
                    TuttiActionUIHandler.this.showAction(action);
                }
            }
        });
        model.addPropertyChangeListener("progressionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProgressionModel oldValue = (ProgressionModel)((Object)evt.getOldValue());
                ProgressionModel newValue = (ProgressionModel)((Object)evt.getNewValue());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("progression model: " + (Object)((Object)newValue)));
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(TuttiActionUIHandler.this.progressionListener);
                }
                if (newValue == null) {
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskPanel().setVisible(false);
                } else {
                    ((TuttiActionUI)TuttiActionUIHandler.this.ui).getTaskPanel().setVisible(true);
                    newValue.addPropertyChangeListener(TuttiActionUIHandler.this.progressionListener);
                }
            }
        });
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        ((TuttiActionUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiActionUIModel> getValidator() {
        return null;
    }
}

