/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportTemporaryVesselExampleAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportTemporaryVesselExampleAction.class);
    private File file;

    public ExportTemporaryVesselExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, "export", I18n._((String)"tutti.action.exportTemporaryVesselExample", (Object[])new Object[0]), I18n._((String)"tutti.action.exportTemporaryVesselExample.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.exportTemporaryVesselExampleFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialVesselFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".csv");
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export example vessels temporary referential to file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.exportTemporaryVesselExample(this.file);
        this.sendMessage("Exemple de r\u00e9f\u00e9rentiel temporaire de navires export\u00e9 dans le fichier " + this.file + ".");
    }
}

