/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategory;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ComputeWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ComputeWeightsAction.class);
    protected String errorMessage;
    protected String errorTitle;
    protected Component errorComponent;

    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, "computeWeights", "generate", I18n._((String)"tutti.action.computeWeights", (Object[])new Object[0]), I18n._((String)"tutti.action.computeWeights.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) throws Exception {
        EditCatchesUIModel model = (EditCatchesUIModel)((Object)this.getModel());
        this.computeSpeciesBatches();
        Float speciesTotalSortedWeight = model.getSpeciesTotalSortedComputedWeight();
        Float speciesTotalUnsortedWeight = model.getSpeciesTotalUnsortedComputedWeight();
        EditCatchesUI ui = (EditCatchesUI)this.getUI();
        model.setCatchTotalSortedComputedWeight(speciesTotalSortedWeight);
        model.setCatchTotalUnsortedComputedWeight(speciesTotalUnsortedWeight);
        Float totalWeight = model.getCatchTotalWeight();
        Float rejectedWeight = model.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue()))) {
                this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
                this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal.title", (Object[])new Object[0]);
                this.errorComponent = ui.getCatchTotalWeightField();
            } else {
                model.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - speciesTotalUnsortedWeight.floatValue() - speciesTotalSortedWeight.floatValue()));
            }
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                model.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            model.setCatchTotalComputedWeight(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue() + rejectedWeight.floatValue()));
        } else if (rejectedWeight != null && !totalWeight.equals(Float.valueOf(speciesTotalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal", (Object[])new Object[0]);
            this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentTotal.title", (Object[])new Object[0]);
            this.errorComponent = ui.getCatchTotalWeightField();
        }
    }

    protected void computeSpeciesBatches() {
        Float inertWeight;
        PersistenceService persistenceService = this.getService(PersistenceService.class);
        EditCatchesUIModel model = (EditCatchesUIModel)((Object)this.getModel());
        Float totalSortedWeight = Float.valueOf(0.0f);
        Float totalUnsortedWeight = Float.valueOf(0.0f);
        SpeciesBatchUI speciesUI = ((EditCatchesUI)this.getUI()).getSpeciesTabContent();
        EditCatchesUI ui = (EditCatchesUI)this.getUI();
        List roots = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows();
        for (SpeciesBatchRowModel row : roots) {
            if (!row.isBatchRoot()) continue;
            Float weight = this.computeSpeciesBatch(row);
            if (weight == null) {
                JOptionPane.showMessageDialog(speciesUI, I18n._((String)"tutti.dialog.catches.species.computeWeight.error.message", (Object[])new Object[0]), I18n._((String)"tutti.dialog.catches.species.computeWeight.error.title", (Object[])new Object[0]), 0);
                totalSortedWeight = null;
                totalUnsortedWeight = null;
                break;
            }
            if (persistenceService.isSortedQualitativeValue(row.getSortedUnsortedCategory().getCategoryValue())) {
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            totalUnsortedWeight = Float.valueOf(totalUnsortedWeight.floatValue() + weight.floatValue());
        }
        if ((inertWeight = model.getSpeciesTotalInertWeight()) != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            model.setSpeciesTotalInertWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = model.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            model.setSpeciesTotalLivingNotItemizedWeight(Float.valueOf(0.0f));
        }
        model.setSpeciesTotalSampleSortedComputedWeight(totalSortedWeight);
        Float speciesTotalSortedWeight = model.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = totalSortedWeight;
            model.setSpeciesTotalSortedComputedWeight(totalSortedWeight);
        } else if (speciesTotalSortedWeight.floatValue() < totalSortedWeight.floatValue()) {
            this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]);
            this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentSpeciesTotalSorted.title", (Object[])new Object[0]);
            this.errorComponent = ui.getSpeciesTotalSortedWeightField();
        } else if ((double)speciesTotalSortedWeight.floatValue() < 1.05 * (double)totalSortedWeight.floatValue()) {
            // empty if block
        }
        model.setSpeciesTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = Float.valueOf(totalUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        model.setSpeciesTotalComputedWeight(totalWeight);
        speciesUI.getTable().repaint();
    }

    protected Float computeSpeciesBatch(SpeciesBatchRowModel row) {
        SampleCategory finestCategory = row.getFinestCategory();
        Float result = null;
        Float categoryWeight = finestCategory.getCategoryWeight();
        Float rowWeight = row.getWeight();
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (!row.isBatchLeaf()) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatchRowModel child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    finestCategory.setComputedWeight(sum);
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(false);
                    }
                } else if (categoryWeight.floatValue() < sum.floatValue()) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]);
                    this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentParentCategoryWeight.title", (Object[])new Object[0]);
                    this.errorComponent = null;
                } else {
                    boolean subSample = categoryWeight.floatValue() > sum.floatValue();
                    for (SpeciesBatchRowModel child : children) {
                        child.getFinestCategory().setSubSample(subSample);
                    }
                }
                result = sum;
            }
        } else {
            row.setComputedWeight(null);
            List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                    Float w = frequencyModel.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight == null && rowWeight != null) {
                    this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightCategory", (Object[])new Object[0]);
                    this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightCategory.title", (Object[])new Object[0]);
                    this.errorComponent = null;
                } else if (categoryWeight == null && frequencyWeight != null) {
                    finestCategory.setComputedWeight(frequencyWeight);
                    result = frequencyWeight;
                } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                    if (categoryWeight != null && frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]);
                        this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentCategoryWeight.title", (Object[])new Object[0]);
                        this.errorComponent = null;
                    } else if (rowWeight == null) {
                        row.setComputedWeight(frequencyWeight);
                    } else if (!rowWeight.equals(frequencyWeight)) {
                        this.errorMessage = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]);
                        this.errorTitle = I18n._((String)"tutti.action.computeWeights.error.incoherentRowWeightFrequency.title", (Object[])new Object[0]);
                        this.errorComponent = null;
                    }
                    result = categoryWeight;
                } else {
                    result = categoryWeight;
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        if (this.errorMessage != null) {
            JOptionPane.showMessageDialog((Component)this.getUI(), this.errorMessage, this.errorTitle, 0);
        }
        if (this.errorComponent != null) {
            this.errorComponent.requestFocus();
        }
        this.errorMessage = null;
        this.errorComponent = null;
    }
}

