/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;

public abstract class FactoryBeanRegistrySupport
extends DefaultSingletonBeanRegistry {
    private final Map<String, Object> factoryBeanObjectCache = new ConcurrentHashMap<String, Object>();

    protected Class getTypeForFactoryBean(final FactoryBean factoryBean) {
        try {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<Class>(){

                    @Override
                    public Class run() {
                        return factoryBean.getObjectType();
                    }
                }, this.getAccessControlContext());
            }
            return factoryBean.getObjectType();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            return null;
        }
    }

    protected Object getCachedObjectForFactoryBean(String beanName) {
        Object object = this.factoryBeanObjectCache.get(beanName);
        return object != NULL_OBJECT ? object : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromFactoryBean(FactoryBean factory, String beanName, boolean shouldPostProcess) {
        if (factory.isSingleton() && this.containsSingleton(beanName)) {
            Object object = this.getSingletonMutex();
            synchronized (object) {
                Object object2 = this.factoryBeanObjectCache.get(beanName);
                if (object2 == null) {
                    object2 = this.doGetObjectFromFactoryBean(factory, beanName, shouldPostProcess);
                    this.factoryBeanObjectCache.put(beanName, object2 != null ? object2 : NULL_OBJECT);
                }
                return object2 != NULL_OBJECT ? object2 : null;
            }
        }
        return this.doGetObjectFromFactoryBean(factory, beanName, shouldPostProcess);
    }

    private Object doGetObjectFromFactoryBean(final FactoryBean factory, String beanName, boolean shouldPostProcess) throws BeanCreationException {
        Object object;
        block10: {
            try {
                if (System.getSecurityManager() != null) {
                    AccessControlContext acc = this.getAccessControlContext();
                    try {
                        object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                return factory.getObject();
                            }
                        }, acc);
                        break block10;
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                }
                object = factory.getObject();
            }
            catch (FactoryBeanNotInitializedException ex) {
                throw new BeanCurrentlyInCreationException(beanName, ex.toString());
            }
            catch (Throwable ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        if (object == null && this.isSingletonCurrentlyInCreation(beanName)) {
            throw new BeanCurrentlyInCreationException(beanName, "FactoryBean which is currently in creation returned null from getObject");
        }
        if (object != null && shouldPostProcess) {
            try {
                object = this.postProcessObjectFromFactoryBean(object, beanName);
            }
            catch (Throwable ex) {
                throw new BeanCreationException(beanName, "Post-processing of the FactoryBean's object failed", ex);
            }
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) throws BeansException {
        return object;
    }

    protected FactoryBean getFactoryBean(String beanName, Object beanInstance) throws BeansException {
        if (!(beanInstance instanceof FactoryBean)) {
            throw new BeanCreationException(beanName, "Bean instance of type [" + beanInstance.getClass() + "] is not a FactoryBean");
        }
        return (FactoryBean)beanInstance;
    }

    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanObjectCache.remove(beanName);
    }

    protected AccessControlContext getAccessControlContext() {
        return AccessController.getContext();
    }
}

