package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiCollectionUniqueKeyValidator.java 476 2013-02-25 20:44:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/TuttiCollectionUniqueKeyValidator.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.opensymphony.xwork2.validator.ValidationException;
import org.nuiton.validator.xwork2.field.CollectionUniqueKeyValidator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * To fix a bug (will be moved back to nuiton-validator) (see
 * http://nuiton.org/issues/2545).
 *
 * TODO Remove this when using nuiton-validator 2.6.10 and reuse the basic validator.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.1
 */
public class TuttiCollectionUniqueKeyValidator extends CollectionUniqueKeyValidator {

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {

        if (keys == null || keys.length == 0) {
            throw new ValidationException("no unique keys defined");
        }

        String fieldName = getFieldName();

        Collection<?> col = getCollection(object);

        if (log.isDebugEnabled()) {
            log.debug("collection found : " + col);
        }
        Object againstBean = againstProperty == null ? null :
                             getFieldValue(againstProperty, object);

        if (log.isDebugEnabled()) {
            log.debug("againtBean = " + againstBean);
        }
        Integer againstIndex = (Integer) (againstIndexExpression == null ?
                                          -1 :
                                          getFieldValue(againstIndexExpression, object));
        if (againstIndex == null) {
            againstIndex = -1;
        }

        if (!againstMe && againstBean == null && col.size() < 2) {
            // la liste ne contient pas deux entrées donc c'est valide
            return;
        }

        if (againstMe) {
            // try on this object
            againstBean = object;
            if (log.isDebugEnabled()) {
                log.debug("againtBean from me = " + againstBean);
            }
        }


        boolean answer = true;

        Integer againstHashCode = againstBean == null ?
                                  null : getUniqueKeyHashCode(againstBean);
        if (log.isDebugEnabled()) {
            log.debug("hash for new key " + againstHashCode);
        }

        if (againstHashCode == null && nullValueSkipped) {

            // clef nulle, donc pas d'erreur vu que le flag a ete positionne
            return;
        }
        List<Integer> hashCodes = new ArrayList<Integer>();

        int index = 0;
        for (Object o : col) {
            Integer hash = getUniqueKeyHashCode(o);

            if (log.isDebugEnabled()) {
                log.debug("hash for object  " + o + " = " + hash);
            }

            if (hash == null && nullValueSkipped) {

                // clef nulle, donc pas d'erreur vu que le flag a ete positionne
                continue;
            }

            if (againstBean == null) {
                if (hashCodes.contains(hash)) {

                    // on a deja rencontre cette clef unique,
                    // donc la validation a echouee
                    answer = false;
                    if (log.isDebugEnabled()) {
                        log.debug("Found same hashcode, not unique!");
                    }
                    break;
                }
            } else {
                // utilisation de againstBean
                if (againstIndex != -1) {
                    if (index != againstIndex &&
                        hash.equals(againstHashCode)) {
                        // on a deja rencontre cette clef unique,
                        // donc la validation a echouee
                        answer = false;
                        break;
                    }
                } else {
                    if (!againstBean.equals(o) &&
                        hash.equals(againstHashCode)) {
                        // on a deja rencontre cette clef unique,
                        // donc la validation a echouee
                        answer = false;
                        break;
                    }
                }
            }
            // nouveau hashcode enregistre
            hashCodes.add(hash);
            // index suivant
            index++;
        }

        if (!answer) {
            addFieldError(fieldName, object);
        }
    }
}
