
package fr.ifremer.tutti.ui.swing.content.program;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveProgramAction.java 384 2013-02-10 15:01:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/program/SaveProgramAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SaveProgramAction extends AbstractTuttiAction<EditProgramUIModel, EditProgramUI, EditProgramUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(SaveProgramAction.class);

    public SaveProgramAction(EditProgramUIHandler handler) {
        super(handler,
              "saveProgram",
              "save",
              _("tutti.action.saveProgram"),
              _("tutti.action.saveProgram.tip"),
              true
        );
    }

    /**
     * If the event source is a TuttiScreen, then the screen changes to the source.
     * Otherwise, the screen changes to the home.
     *
     * @param event
     */
    @Override
    protected void doAction(ActionEvent event) {
        TuttiUIContext context = getContext();
        PersistenceService persistenceService =
                getService(PersistenceService.class);

        EditProgramUIModel model = getModel();

        Program bean = model.toBean();

        Program saved;
        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createProgram(bean);
        } else {
            saved = persistenceService.saveProgram(bean);
        }

        context.setProgramId(saved.getId());

        TuttiScreen nextScreen;
        if (event.getSource().getClass().isAssignableFrom(TuttiScreen.class)) {
            nextScreen = (TuttiScreen) event.getSource();
        } else {
            nextScreen = TuttiScreen.SELECT_CRUISE;
        }
        context.setScreen(nextScreen);
    }

}
