package fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting;

/*
 * #%L
 * Tutti :: UI
 * $Id: GearShootingTabUIHandler.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/gearshooting/GearShootingTabUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.CaracteristicTabUIHandler;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

import java.util.List;

/**
 * @author kmorin
 * @since 0.3
 */
public class GearShootingTabUIHandler extends CaracteristicTabUIHandler<GearShootingRowModel, GearShootingTabUIModel, GearShootingTableModel, GearShootingTabUI> {

    private final static Log log =
            LogFactory.getLog(GearShootingTabUIHandler.class);

    public GearShootingTabUIHandler(EditFishingOperationUI parentUi,
                                    GearShootingTabUI ui) {
        super(parentUi, ui, GearShootingRowModel.PROPERTY_VALUE);
    }

    //------------------------------------------------------------------------//
    //-- CaracteristicTabUIHandler methods                                  --//
    //------------------------------------------------------------------------//

    @Override
    protected BeanComboBox<Caracteristic> getKeyCombo() {
        return ui.getNewRowKey();
    }

    @Override
    protected GearShootingTabUIModel createModel() {
        return new GearShootingTabUIModel();
    }

    @Override
    protected CaracteristicMap getCaracteristics(FishingOperation operation) {
        return operation.getGearShootingCaracteristics();
    }

    @Override
    protected List<String> getProtocolPmfmIds(TuttiProtocol protocol) {
        return protocol.getGearPmfmId();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiTableUIHandler methods                                --//
    //------------------------------------------------------------------------//

    @Override
    public JXTable getTable() {
        return ui.getGearShootingTable();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void afterInitUI() {
        super.afterInitUI();

        JXTable table = getTable();

        // create table column model
        DefaultTableColumnModelExt columnModel =
                new DefaultTableColumnModelExt();

        {

            addColumnToModel(columnModel,
                             null,
                             newTableCellRender(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT),
                             GearShootingTableModel.KEY);
        }

        {

            addColumnToModel(columnModel,
                             new CaracteristicValueEditor(context),
                             new CaracteristicValueRenderer(context),
                             GearShootingTableModel.VALUE);
        }

        // create table model
        GearShootingTableModel tableModel =
                new GearShootingTableModel(columnModel);

        table.setModel(tableModel);
        table.setColumnModel(columnModel);

        initTable(table);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void removeCaracteristic() {
        int rowIndex = getTable().getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove caracteristic if no caracteristic selected");

        GearShootingRowModel row = getTableModel().getEntry(rowIndex);

        CaracteristicMap caracteristicMap = getModel().getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove(row.getKey());
        }

        //add the row in the combo
        BeanComboBox keyCombo = ui.getNewRowKey();
        keyCombo.addItem(row.getKey());
        selectFirstInCombo(keyCombo);

        // remove the row from the model
        getModel().getRows().remove(rowIndex);

        // refresh all the table
        getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);

        getModel().removeRowInError(row);

    }

}
