package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCatchesUI extends JPanel implements TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN = "catchTotalRejectedWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalRejectedWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "catchTotalSortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN = "catchTotalWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo accidentalTab;
    protected TabInfo benthosTab;
    protected Table benthosTable;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSampleSortedWeight",  editorName = "benthosTotalSampleSortedWeightField")
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected JTextField benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalUnsortedWeight",  editorName = "benthosTotalUnsortedWeightField")
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected JButton cancelButton;
    protected Table catchTable;
    protected JLabel catchThalassaLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    protected JTextField catchTotalSortedWeightField;
    protected JLabel catchTotalSortedWeightLabel;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected TuttiComputedOrNotDataEditor catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected Table catchesForm;
    protected JButton computeSpeciesBatchButton;
    protected JPanel createFishingOperationActions;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected EditCatchesUIHandler handler;
    protected EditCatchesUI homePanel = this;
    protected JButton importPupitriButton;
    protected TabInfo macroWasteTab;
    protected Table macroWasteTable;
    @ValidatorField( validatorId = "validator",  propertyName = "macroWasteTotalWeight",  editorName = "macroWasteTotalWeightField")
    protected JTextField macroWasteTotalWeightField;
    protected JLabel macroWasteTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected TabInfo observationIndividuelTab;
    protected TabInfo planktonTab;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected Table speciesTable;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected JTextField speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditCatchesUIHandler handler = new EditCatchesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public JTextField getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public JLabel getCatchThalassaLabel() {
        return catchThalassaLabel;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public JTextField getCatchTotalSortedWeightField() {
        return catchTotalSortedWeightField;
    }

    public JLabel getCatchTotalSortedWeightLabel() {
        return catchTotalSortedWeightLabel;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public TabInfo getMacroWasteTab() {
        return macroWasteTab;
    }

    public Table getMacroWasteTable() {
        return macroWasteTable;
    }

    public JTextField getMacroWasteTotalWeightField() {
        return macroWasteTotalWeightField;
    }

    public JLabel getMacroWasteTotalWeightLabel() {
        return macroWasteTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public TabInfo getObservationIndividuelTab() {
        return observationIndividuelTab;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public JTextField getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightField, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchThalassaLabel, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(macroWasteTable, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add($JPanel1, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
        createFishingOperationActions.add(computeSpeciesBatchButton);
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPane, BorderLayout.CENTER);
        add($JPanel2, BorderLayout.SOUTH);
    }

    protected void addChildrenToMacroWasteTable() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTable.add(macroWasteTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        macroWasteTable.add(SwingUtil.boxComponentWithJxLayer(macroWasteTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.species"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
        
        accidentalTab.setTitle(_("tutti.label.tab.accidentel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new JTextField());
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setColumns(15);
        benthosTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSortedWeight"));
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.label.catches.benthosTotalUnsortedWeight"));
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.label.catches.benthosTotalWeight"));
        benthosTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("tuttiAction", CancelEditCatchBatchAction.class);
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchThalassaLabel() {
        $objectMap.put("catchThalassaLabel", catchThalassaLabel = new JLabel());
        
        catchThalassaLabel.setName("catchThalassaLabel");
        catchThalassaLabel.setText(_("tutti.label.catches.catchThalassa"));
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setDecimalNumber(3);
        catchTotalRejectedWeightField.setUseFloat(true);
        catchTotalRejectedWeightField.setShowReset(true);
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(_("tutti.label.catches.catchTotalRejectedWeight"));
    }

    protected void createCatchTotalSortedWeightField() {
        $objectMap.put("catchTotalSortedWeightField", catchTotalSortedWeightField = new JTextField());
        
        catchTotalSortedWeightField.setName("catchTotalSortedWeightField");
        catchTotalSortedWeightField.setColumns(15);
        catchTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalSortedWeightLabel() {
        $objectMap.put("catchTotalSortedWeightLabel", catchTotalSortedWeightLabel = new JLabel());
        
        catchTotalSortedWeightLabel.setName("catchTotalSortedWeightLabel");
        catchTotalSortedWeightLabel.setText(_("tutti.label.catches.catchTotalSortedWeight"));
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(_("tutti.label.catches.catchTotalUnsortedWeight"));
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new TuttiComputedOrNotDataEditor(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setDecimalNumber(3);
        catchTotalWeightField.setUseFloat(true);
        catchTotalWeightField.setShowReset(true);
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(_("tutti.label.catches.catchTotalWeight"));
        catchTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.putClientProperty("tuttiAction", ComputeWeightsAction.class);
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCatchesUIHandler.class));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.putClientProperty("tuttiAction", ImportPupitriAction.class);
    }

    protected void createMacroWasteTab() {
        $objectMap.put("macroWasteTab", macroWasteTab = new TabInfo());
        
        macroWasteTab.setTitle(_("tutti.label.tab.macroDechet"));
    }

    protected void createMacroWasteTable() {
        $objectMap.put("macroWasteTable", macroWasteTable = new Table());
        
        macroWasteTable.setName("macroWasteTable");
    }

    protected void createMacroWasteTotalWeightField() {
        $objectMap.put("macroWasteTotalWeightField", macroWasteTotalWeightField = new JTextField());
        
        macroWasteTotalWeightField.setName("macroWasteTotalWeightField");
        macroWasteTotalWeightField.setColumns(15);
        macroWasteTotalWeightField.putClientProperty("computed", true);
    }

    protected void createMacroWasteTotalWeightLabel() {
        $objectMap.put("macroWasteTotalWeightLabel", macroWasteTotalWeightLabel = new JLabel());
        
        macroWasteTotalWeightLabel.setName("macroWasteTotalWeightLabel");
        macroWasteTotalWeightLabel.setText(_("tutti.label.catches.macroWasteTotalWeight"));
        macroWasteTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createObservationIndividuelTab() {
        $objectMap.put("observationIndividuelTab", observationIndividuelTab = new TabInfo());
        
        observationIndividuelTab.setTitle(_("tutti.label.tab.observationIndividuel"));
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.putClientProperty("tuttiAction", SaveCatchBatchAction.class);
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
        
        speciesTab.setTitle(_("tutti.label.tab.species"));
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("italicStyle", true);
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new JTextField());
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setColumns(15);
        speciesTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
        speciesTotalWeightLabel.putClientProperty("strongStyle", true);
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMacroWasteTable();
        // inline complete setup of $JPanel1
        $JPanel1.add(importPupitriButton);
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        // inline complete setup of $JPanel2
        $JPanel2.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 33 property setters
        catchTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedWeightLabel.setLabelFor(catchTotalSortedWeightField);
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchThalassaLabel.setIcon(SwingUtil.createActionIcon("information"));
        speciesTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        benthosTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        macroWasteTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.macroWaste")));
        macroWasteTotalWeightLabel.setLabelFor(macroWasteTotalWeightField);
        benthosTab.setEnabled(false);
        planktonTab.setEnabled(false);
        macroWasteTab.setEnabled(false);
        accidentalTab.setEnabled(false);
        observationIndividuelTab.setEnabled(false);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedWeightLabel();
        createCatchTotalSortedWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createCatchThalassaLabel();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMacroWasteTable();
        createMacroWasteTotalWeightLabel();
        createMacroWasteTotalWeightField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createImportPupitriButton();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createPlanktonTab();
        createMacroWasteTab();
        createAccidentalTab();
        createObservationIndividuelTab();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setBean(model.getCatchTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedWeightField, getWeightStringValue(model.getCatchTotalSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, getWeightStringValue(model.getCatchTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setBean(model.getCatchTotalRejectedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalRejectedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, getWeightStringValue(model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSortedWeightField, getStringValue(model.getSpeciesTotalSortedWeight() != null ?
                                            String.format("%.3f", model.getSpeciesTotalSortedWeight()) : 
                                            model.getSpeciesTotalSortedComputedWeight() != null ?
                                            String.format("%.3f", model.getSpeciesTotalSortedComputedWeight()) :
                                            null));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, getWeightStringValue(model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getWeightStringValue(model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
    }

}