package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCatchesAction.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/EditCatchesAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * Opens the catches edition screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditCatchesAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    private static final long serialVersionUID = 1L;

    public EditCatchesAction(SelectCruiseUIHandler handler) {
        super(handler,
              "editCatches",
              "edit",
              _("tutti.action.editCatches"),
              _("tutti.action.editCatches.tip"),
              true
        );
    }

    @Override
    protected void doAction(ActionEvent e) {
        Preconditions.checkState(getContext().isCruiseFilled());
        getContext().setValidationContext(TuttiUIContext.VALIDATION_CONTEXT_EDIT);
        getContext().setScreen(TuttiScreen.EDIT_FISHING_OPERATION);
    }
}
