package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

/*
 * #%L
 * Tutti :: UI
 * $Id: HydrologyRowModel.java 129 2012-12-29 20:50:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/hydrology/HydrologyRowModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.Serializable;

/**
 * @author kmorin
 * @since 0.3
 */
public class HydrologyRowModel extends AbstractTuttiBeanUIModel<Caracteristic, HydrologyRowModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_KEY = "key";

    public static final String PROPERTY_GEAR_SHOOTING_START_VALUE = "gearShootingStartValue";

    public static final String PROPERTY_GEAR_SHOOTING_END_VALUE = "gearShootingEndValue";

    public static final String PROPERTY_AVERAGE_VALUE = "averageValue";

    protected static final Binder<Caracteristic, HydrologyRowModel> fromBeanBinder =
            BinderFactory.newBinder(Caracteristic.class,
                                    HydrologyRowModel.class);

    protected static final Binder<HydrologyRowModel, Caracteristic> toBeanBinder =
            BinderFactory.newBinder(HydrologyRowModel.class,
                                    Caracteristic.class);

    protected Caracteristic key;

    protected Serializable gearShootingStartValue;

    protected Serializable gearShootingEndValue;

    protected Serializable averageValue;

    public HydrologyRowModel() {
        super(Caracteristic.class, fromBeanBinder, toBeanBinder);
    }

    public HydrologyRowModel(Caracteristic key) {
        this(key, null, null, null);
    }

    public HydrologyRowModel(Caracteristic key, Serializable gearShootingStartValue,
                             Serializable gearShootingEndValue, Serializable averageValue) {
        this();
        this.key = key;
        this.gearShootingStartValue = gearShootingStartValue;
        this.gearShootingEndValue = gearShootingEndValue;
        this.averageValue = averageValue;
    }

    public Caracteristic getKey() {
        return key;
    }

    public void setKey(Caracteristic key) {
        Object oldValue = getKey();
        this.key = key;
        firePropertyChange(PROPERTY_KEY, oldValue, key);
    }

    public Serializable getGearShootingStartValue() {
        return gearShootingStartValue;
    }

    public void setGearShootingStartValue(Serializable gearShootingStartValue) {
        Object oldValue = getGearShootingStartValue();
        this.gearShootingStartValue = gearShootingStartValue;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_VALUE, oldValue, gearShootingStartValue);
    }

    public Serializable getGearShootingEndValue() {
        return gearShootingEndValue;
    }

    public void setGearShootingEndValue(Serializable gearShootingEndValue) {
        Object oldValue = getGearShootingEndValue();
        this.gearShootingEndValue = gearShootingEndValue;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_VALUE, oldValue, gearShootingEndValue);
    }

    public Serializable getAverageValue() {
        return averageValue;
    }

    public void setAverageValue(Serializable averageValue) {
        Object oldValue = getAverageValue();
        this.averageValue = averageValue;
        firePropertyChange(PROPERTY_AVERAGE_VALUE, oldValue, averageValue);
    }

}
