/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPreScript;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class SimulationPreScriptListener
implements SimulationListener {
    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
        try {
            context.message(I18n.t((String)"isisfish.message.presimulation.script.execution", (Object[])new Object[0]));
            SimulationStorage simulation = context.getSimulationStorage();
            SimulationParameter parameters = simulation.getParameter();
            String generatedPreScript = parameters.getGeneratedPreScript();
            String presimulationScript = parameters.getPreScript();
            if (StringUtils.isNotBlank((CharSequence)generatedPreScript) || parameters.getUsePreScript() && StringUtils.isNotBlank((CharSequence)presimulationScript)) {
                TopiaContext tx = context.getDB();
                if (StringUtils.isNotBlank((CharSequence)generatedPreScript)) {
                    EvaluatorHelper.evaluate(SimulationPreScript.class.getPackage().getName(), "GeneratedPreScript", SimulationPreScript.class, generatedPreScript, context, tx);
                }
                if (parameters.getUsePreScript() && StringUtils.isNotBlank((CharSequence)presimulationScript)) {
                    EvaluatorHelper.evaluate(SimulationPreScript.class.getPackage().getName(), "PreScript", SimulationPreScript.class, presimulationScript, context, tx);
                }
                tx.commitTransaction();
            }
        }
        catch (Exception eee) {
            throw new SimulationException(I18n.t((String)"Can't evaluate simulation prescript", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void stepChange(SimulationContext context, TimeStep step) {
    }
}

