package fr.ifremer.isisfish.ui.sensitivity;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SensitivitySecondPassUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISPLAY_SECOND_PASS_BUTTON_ENABLED = "displaySecondPassButton.enabled";
    public static final String BINDING_RUN_SECOND_PASS_BUTTON_ENABLED = "runSecondPassButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz08TQRR+rbSlIIpWfhgwqUBMNGbLRQ9C+GkIkKqEakLsxWl3SodMd8eZt7BcjH+Cf4LevZh482Q8ePbgxfgvGOPBq/HNtnQpVCT0MLt5b77vfe/1e/v2B6SMhus7LAwdHXgoGtxZX9zaelTZ4VW8z01VC4W+huYvkYRkGfrddtwgTJaLFl5owQvLfkP5HvcOoWeK0GdwX3JT5xwRrnUiqsYUSu30TKgCfcDaFtWN9fWvn8lX7ss3SYBQkboMtZL/HyrupKcISeEiXKZKu6wgmbdNMrTwtknvgI0tS2bMQ9bgz+EFZIqQVkwTGcLE6VuOOCJ8qBAyU49ZRfJphHs17Yia5g1OTyNMTZi6EwjHcM8IFLsC951S/F7iVd9zN4jryZpSEWGa6OrMcyXXCPNnpVttMsSc+Zrg0j18VzQCyVD4XolLcgXCkB1O6Jg9mpWzTt1X/CU/tPhsmyZHw4mrLAWIvkfRDmQz2okbcYVRku0fxdr0lc6rA1Prpar2pdxgnh3pSAd5nOpETSIPcVFzdmwcioptchPIYy0+bkEsxYgim4112IwM7MQGjh2WKENKBxRGGC0f9/wmpZpuHz3idksYZf8M575++P5+5cDiaao91PXqoQ0l6yntK7KFsKUvNv0doJCFB0zNlCFroj8yWt/xLsJKrTSJo3qXLNyxcGeVmTpRpDLfPn4afvblHCRXoE/6zF1h9v4aZLGuaQq+dEM1vxApOr/XS+eg1YaQavgulwgXZl2GLF8RnksDngtpBuNdZtAWUsl+/p0rvVs4mEOCdF395/V4FqmnkBaeFB6Plr21x12Xu18ZHrh+vK/dNjhhn4OqtS0T0XmjW6MZ7tlFjyreDAP7uBXptm+3I5rcKWh6rFnpEzXbbCLPkD5QlQD53Fk5bXj6BFXDp2K4Y4+7Z2VA6OWuQDugE3jGiOcvvMM/CaEGAAA=";
    private static final Log log = LogFactory.getLog(SensitivitySecondPassUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton displaySecondPassButton;
    protected JComboBox<String> fieldSensitivitySimulationSelect;
    protected SensitivitySecondPassHandler handler;
    protected JButton runSecondPassButton;
    protected JTextArea textAreaSensitivitySecondpassResult;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private SensitivitySecondPassUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SensitivitySecondPassUI() {
        $initialize();
    }

    public SensitivitySecondPassUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__displaySecondPassButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.displaySensitivitySecondPass(event);
    }

    public void doActionPerformed__on__runSecondPassButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.launchSecondPass(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getDisplaySecondPassButton() {
        return displaySecondPassButton;
    }

    public JComboBox<String> getFieldSensitivitySimulationSelect() {
        return fieldSensitivitySimulationSelect;
    }

    public SensitivitySecondPassHandler getHandler() {
        return handler;
    }

    public JButton getRunSecondPassButton() {
        return runSecondPassButton;
    }

    public JTextArea getTextAreaSensitivitySecondpassResult() {
        return textAreaSensitivitySecondpassResult;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createDisplaySecondPassButton() {
        $objectMap.put("displaySecondPassButton", displaySecondPassButton = new JButton());
        
        displaySecondPassButton.setName("displaySecondPassButton");
        displaySecondPassButton.setText(t("isisfish.sensitivity.displaysecondpass"));
        displaySecondPassButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__displaySecondPassButton"));
    }

    protected void createFieldSensitivitySimulationSelect() {
        $objectMap.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect = new JComboBox<String>());
        
        fieldSensitivitySimulationSelect.setName("fieldSensitivitySimulationSelect");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SensitivitySecondPassHandler(this));
    }

    protected void createRunSecondPassButton() {
        $objectMap.put("runSecondPassButton", runSecondPassButton = new JButton());
        
        runSecondPassButton.setName("runSecondPassButton");
        runSecondPassButton.setText(t("isisfish.sensitivity.secondpass"));
        runSecondPassButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__runSecondPassButton"));
    }

    protected void createTextAreaSensitivitySecondpassResult() {
        $objectMap.put("textAreaSensitivitySecondpassResult", textAreaSensitivitySecondpassResult = new JTextArea());
        
        textAreaSensitivitySecondpassResult.setName("textAreaSensitivitySecondpassResult");
        textAreaSensitivitySecondpassResult.setColumns(15);
        textAreaSensitivitySecondpassResult.setLineWrap(true);
        textAreaSensitivitySecondpassResult.setWrapStyleWord(true);
        textAreaSensitivitySecondpassResult.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(fieldSensitivitySimulationSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(runSecondPassButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(displaySecondPassButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(textAreaSensitivitySecondpassResult);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldSensitivitySimulationSelect.setModel(handler.getSensitivitySimulationModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createFieldSensitivitySimulationSelect();
        createRunSecondPassButton();
        createDisplaySecondPassButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTextAreaSensitivitySecondpassResult();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RUN_SECOND_PASS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
                    fieldSensitivitySimulationSelect.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    runSecondPassButton.setEnabled(fieldSensitivitySimulationSelect.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DISPLAY_SECOND_PASS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    $bindingSources.put("fieldSensitivitySimulationSelect", fieldSensitivitySimulationSelect);
                    fieldSensitivitySimulationSelect.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    displaySecondPassButton.setEnabled(fieldSensitivitySimulationSelect.getSelectedItem() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fieldSensitivitySimulationSelect != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("fieldSensitivitySimulationSelect");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u1"));
                    }
                }
            }
        
            public void $pr$u1(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}