package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PopulationMigrationUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POP_INFO = "popInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_COMMENT_ENABLED = "fieldPopulationMigrationComment.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_COMMENT_TEXT = "fieldPopulationMigrationComment.text";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_SEASON_CHOOSER_ENABLED = "fieldPopulationMigrationSeasonChooser.enabled";
    public static final String BINDING_FIELD_USE_EQUATION_MIGRATION_ENABLED = "fieldUseEquationMigration.enabled";
    public static final String BINDING_FIELD_USE_EQUATION_MIGRATION_SELECTED = "fieldUseEquationMigration.selected";
    public static final String BINDING_FIELD_USE_MATRIX_ENABLED = "fieldUseMatrix.enabled";
    public static final String BINDING_POPULATION_MIGRATION_EMIGRATION_UI_ACTIVE = "populationMigrationEmigrationUI.active";
    public static final String BINDING_POPULATION_MIGRATION_EMIGRATION_UI_BEAN = "populationMigrationEmigrationUI.bean";
    public static final String BINDING_POPULATION_MIGRATION_EMIGRATION_UI_POP_INFO = "populationMigrationEmigrationUI.popInfo";
    public static final String BINDING_POPULATION_MIGRATION_EQUATION_UI_ACTIVE = "populationMigrationEquationUI.active";
    public static final String BINDING_POPULATION_MIGRATION_EQUATION_UI_BEAN = "populationMigrationEquationUI.bean";
    public static final String BINDING_POPULATION_MIGRATION_EQUATION_UI_POP_INFO = "populationMigrationEquationUI.popInfo";
    public static final String BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_ACTIVE = "populationMigrationImmigrationUI.active";
    public static final String BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_BEAN = "populationMigrationImmigrationUI.bean";
    public static final String BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_POP_INFO = "populationMigrationImmigrationUI.popInfo";
    public static final String BINDING_POPULATION_MIGRATION_MIGRATION_UI_ACTIVE = "populationMigrationMigrationUI.active";
    public static final String BINDING_POPULATION_MIGRATION_MIGRATION_UI_BEAN = "populationMigrationMigrationUI.bean";
    public static final String BINDING_POPULATION_MIGRATION_MIGRATION_UI_POP_INFO = "populationMigrationMigrationUI.popInfo";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_SEASON_BEAN = "validatorSeason.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8bRRSfmNiOm35B1C/SEFNctSqwTishIaWkbYxDHJxS4QZFdSU66x3H0653NjOz6eaC+BM4cwEkjlyQuHFCHDhz4IL4FyrEgSviza6960k2m1XXh931vPd+7/fevJn3fniBioKjN59i3ze450g6JMbGve3tT8ynpCc/JKLHqSsZR+FvqoAKXTRrRetCore6bWVeH5nXG2zoMoc4E9bLbXRCyH2biAEhUqIF3aInRL0TiZd91+Nj1IhUEuq3//xd+Mr68rsCQr4L7OYhlOpxVnEk021UoJZEr4GnPVy3sbMDNDh1doDvKbXWsLEQ9/GQ7KIvULmNSi7mACbRlewhBxiBve9KdLbWclxPNpgjQX2rtSTRB31u0D4nQwJvQUWfioHhUYMqRcNlrmdjSZljPIg+N+kODz62Wq4bgJckmjYJdiS6lgQHvqikRExgxIZl8NFy+kyimxltOwQL5iibCZQBdiybcIlWcwS0HoLEsJU9bFMLQ0Ylelvb20hgiOewZ0ZHPT8bL8YIZyLFkLZavhCLZ3tAfIdsMovYEl1P5d6IVSfzzqx9qCJVMP6Iy8YD7EzqlGsPsWkT2O2LWgyhdiBTmguRwUxto41NYi8dBA5WlVI10r3ap8S2EpIZxtsYMCbUvpzTgKBmTbbKfB3rUoC1JUhz19PBDtkPSO/ZIfuTA0g1RBPEr9YWdfnpMf4mhpPmS3RBA4VMmMRSxkr/ncjsDfdwdBOHQKK1HDU3AaTcGZHXaoLX1nA46Xc9h18NSve8mOC5qTn+KIfj5pF+F5L8jipBeW3m8Rrh6Hs7LvWb6v9VvVxO1TY6Pc5sW5XE0sFqiUW61eJRBwJqfhjc33opPyS+vMcJVuZ3Dp7ZgNYV3cG0wHtEojkNZdWTMrxdmpFiqYedXngQWrqkotDVDQpRvZ58J+j3a2QQELqfILg1FnA0ryFCfzXi/ho3wKkuKnIPluFa6h5uyZ+CKGzGFw80YwUYSP87P/fHz3/9tDbuwFXwfS5RdWKAgM7ocubClUSV6zNh+/Ukteub2F3uooogNkwfwXRxOYFYZyQGcuDvVWVuKHNjHYsBQBTLf/7y6/knv7+CCmvohM2wtYaVfgtV5IBDFpht+e6duwGjk89n4HlWcYM9D5sBDAWnb0PLwFWTOhZsx4oPWbickIWIiln57d+5zo93x5mYAmaXjlSPs1F8hErUsalDgmlkNGgkTh+zriCexeKBImnEmFLveXdUHtvB83FSqMWgLSrx576nXk8C1urLzAxSJo46I2kwtQww0xJOIHS622EmqlhCczA9SVZeFlMtP0thdS1Lhoaq0ecEmYGB0SKc8Fw4x4VzIwuT8FSlbtbxOGrZVY/dl2dSsvE+82QKj3dzZ6SehQfcCnSPpKDcylK8au7OiTEewXPBqOWvUxDey4TwTW6E73MjpEXxfu4osiGkRZENIS2K5dxRZENIiyIbQtohW8l9XWRDSOPQyM4hF0Iah/XceciGkMbh49wcFML/lXqpyRESAAA=";
    private static final Log log = LogFactory.getLog(PopulationMigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JTextArea fieldPopulationMigrationComment;
    protected JComboBox<PopulationSeasonInfo> fieldPopulationMigrationSeasonChooser;
    protected JCheckBox fieldUseEquationMigration;
    protected JTabbedPane fieldUseMatrix;
    protected PopulationMigrationHandler handler;
    protected JPanel hidablePanel;
    protected PopulationSeasonInfo popInfo;
    protected PopulationMigrationEmigrationUI populationMigrationEmigrationUI;
    protected PopulationMigrationEquationUI populationMigrationEquationUI;
    protected PopulationMigrationImmigrationUI populationMigrationImmigrationUI;
    protected PopulationMigrationMigrationUI populationMigrationMigrationUI;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSeason")
    protected SwingValidator<PopulationSeasonInfo> validatorSeason;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JScrollPane $JScrollPane0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            populationMigrationEquationUI.setLayer(active);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationUI() {
        $initialize();
    }

    public PopulationMigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__fieldPopulationMigrationSeasonChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.seasonChanged();
    }

    public void doActionPerformed__on__fieldUseEquationMigration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.useEquationChanged();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);validatorSeason.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationMigrationComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setMigrationComment(fieldPopulationMigrationComment.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JTextArea getFieldPopulationMigrationComment() {
        return fieldPopulationMigrationComment;
    }

    public JComboBox<PopulationSeasonInfo> getFieldPopulationMigrationSeasonChooser() {
        return fieldPopulationMigrationSeasonChooser;
    }

    public JCheckBox getFieldUseEquationMigration() {
        return fieldUseEquationMigration;
    }

    public JTabbedPane getFieldUseMatrix() {
        return fieldUseMatrix;
    }

    public PopulationMigrationHandler getHandler() {
        return handler;
    }

    public JPanel getHidablePanel() {
        return hidablePanel;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public PopulationMigrationEmigrationUI getPopulationMigrationEmigrationUI() {
        return populationMigrationEmigrationUI;
    }

    public PopulationMigrationEquationUI getPopulationMigrationEquationUI() {
        return populationMigrationEquationUI;
    }

    public PopulationMigrationImmigrationUI getPopulationMigrationImmigrationUI() {
        return populationMigrationImmigrationUI;
    }

    public PopulationMigrationMigrationUI getPopulationMigrationMigrationUI() {
        return populationMigrationMigrationUI;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    public SwingValidator<PopulationSeasonInfo> getValidatorSeason() {
        return validatorSeason;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToFieldUseMatrix() {
        if (!allComponentsCreated) {
            return;
        }
        fieldUseMatrix.add(SwingUtil.boxComponentWithJxLayer(populationMigrationMigrationUI));
        fieldUseMatrix.add(SwingUtil.boxComponentWithJxLayer(populationMigrationImmigrationUI));
        fieldUseMatrix.add(SwingUtil.boxComponentWithJxLayer(populationMigrationEmigrationUI));
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(fieldUseMatrix, 0));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(fieldUseMatrix, 1));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(fieldUseMatrix, 2));
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add(fieldUseMatrix, "fieldUseMatrix");
        hidablePanel.add(populationMigrationEquationUI, "fieldUseEquation");
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorSeason() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSeason.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldPopulationMigrationComment() {
        $objectMap.put("fieldPopulationMigrationComment", fieldPopulationMigrationComment = new JTextArea());
        
        fieldPopulationMigrationComment.setName("fieldPopulationMigrationComment");
        fieldPopulationMigrationComment.setColumns(15);
        fieldPopulationMigrationComment.setLineWrap(true);
        fieldPopulationMigrationComment.setWrapStyleWord(true);
        fieldPopulationMigrationComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMigrationComment"));
    }

    protected void createFieldPopulationMigrationSeasonChooser() {
        $objectMap.put("fieldPopulationMigrationSeasonChooser", fieldPopulationMigrationSeasonChooser = new JComboBox<PopulationSeasonInfo>());
        
        fieldPopulationMigrationSeasonChooser.setName("fieldPopulationMigrationSeasonChooser");
        fieldPopulationMigrationSeasonChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationSeasonChooser"));
    }

    protected void createFieldUseEquationMigration() {
        $objectMap.put("fieldUseEquationMigration", fieldUseEquationMigration = new JCheckBox());
        
        fieldUseEquationMigration.setName("fieldUseEquationMigration");
        fieldUseEquationMigration.setText(t("isisfish.populationMigration.useEquation"));
        fieldUseEquationMigration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldUseEquationMigration"));
    }

    protected void createFieldUseMatrix() {
        $objectMap.put("fieldUseMatrix", fieldUseMatrix = new JTabbedPane());
        
        fieldUseMatrix.setName("fieldUseMatrix");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationMigrationHandler(this));
    }

    protected void createHidablePanel() {
        $objectMap.put("hidablePanel", hidablePanel = new JPanel());
        
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout(new java.awt.CardLayout());
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationEmigrationUI() {
        $objectMap.put("populationMigrationEmigrationUI", populationMigrationEmigrationUI = new PopulationMigrationEmigrationUI(this));
        
        populationMigrationEmigrationUI.setName("populationMigrationEmigrationUI");
        populationMigrationEmigrationUI.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        populationMigrationEmigrationUI.putClientProperty("sensitivityMethod", "EmigrationMatrix");
    }

    protected void createPopulationMigrationEquationUI() {
        $objectMap.put("populationMigrationEquationUI", populationMigrationEquationUI = new PopulationMigrationEquationUI(this));
        
        populationMigrationEquationUI.setName("populationMigrationEquationUI");
    }

    protected void createPopulationMigrationImmigrationUI() {
        $objectMap.put("populationMigrationImmigrationUI", populationMigrationImmigrationUI = new PopulationMigrationImmigrationUI(this));
        
        populationMigrationImmigrationUI.setName("populationMigrationImmigrationUI");
        populationMigrationImmigrationUI.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        populationMigrationImmigrationUI.putClientProperty("sensitivityMethod", "ImmigrationMatrix");
    }

    protected void createPopulationMigrationMigrationUI() {
        $objectMap.put("populationMigrationMigrationUI", populationMigrationMigrationUI = new PopulationMigrationMigrationUI(this));
        
        populationMigrationMigrationUI.setName("populationMigrationMigrationUI");
        populationMigrationMigrationUI.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        populationMigrationMigrationUI.putClientProperty("sensitivityMethod", "MigrationMatrix");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "migration"));
    }

    protected void createValidatorSeason() {
        $objectMap.put("validatorSeason", validatorSeason = SwingValidator.newValidator(PopulationSeasonInfo.class, "migration"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorSeason();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationSeasonChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldUseEquationMigration), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(hidablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToHidablePanel();
        addChildrenToFieldUseMatrix();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationMigrationComment));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 26 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        fieldPopulationMigrationSeasonChooser.setModel(new fr.ifremer.isisfish.ui.models.common.GenericComboModel<PopulationSeasonInfo>());
        fieldPopulationMigrationSeasonChooser.setRenderer(new PopulationSeasonInfoComboRenderer());
        $TabInfo0.setTitle(t("isisfish.populationMigrationMigration.title"));
        $TabInfo1.setTitle(t("isisfish.populationMigrationImmigration.title"));
        $TabInfo2.setTitle(t("isisfish.populationMigrationEmigration.title"));
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createHandler();
        createValidator();
        createValidatorSeason();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationMigration.selectSeason"));
        createFieldPopulationMigrationSeasonChooser();
        createFieldUseEquationMigration();
        createHidablePanel();
        createFieldUseMatrix();
        createPopulationMigrationMigrationUI();
        createPopulationMigrationImmigrationUI();
        createPopulationMigrationEmigrationUI();
        createPopulationMigrationEquationUI();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationMigration.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationMigrationComment();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSave();
        createCancel();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 26 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 26 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_SEASON_BEAN, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                validatorSeason.setBean(getPopInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setChanged(validator.isChanged() || validatorSeason.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setValid(validator.isValid() && validatorSeason.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_SEASON_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationSeasonChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_EQUATION_MIGRATION_ENABLED, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                fieldUseEquationMigration.setEnabled(getPopInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_USE_EQUATION_MIGRATION_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("popInfo", this);
                if (getPopInfo() != null) {
                    getPopInfo().addPropertyChangeListener("useEquationMigration", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopInfo() != null) {
                    fieldUseEquationMigration.setSelected(getPopInfo().isUseEquationMigration());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("popInfo", this);
                if (getPopInfo() != null) {
                    getPopInfo().removePropertyChangeListener("useEquationMigration", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_MATRIX_ENABLED, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                fieldUseMatrix.setEnabled(getPopInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_MIGRATION_UI_ACTIVE, true ,"active" ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationMigrationUI.setActive(isActive() && getPopInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_MIGRATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationMigrationMigrationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_MIGRATION_UI_POP_INFO, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationMigrationUI.setPopInfo(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_ACTIVE, true ,"active" ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationImmigrationUI.setActive(isActive() && getPopInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationMigrationImmigrationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_IMMIGRATION_UI_POP_INFO, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationImmigrationUI.setPopInfo(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EMIGRATION_UI_ACTIVE, true ,"active" ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEmigrationUI.setActive(isActive() && getPopInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EMIGRATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEmigrationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EMIGRATION_UI_POP_INFO, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEmigrationUI.setPopInfo(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EQUATION_UI_ACTIVE, true ,"active" ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEquationUI.setActive(isActive() && getPopInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EQUATION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEquationUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EQUATION_UI_POP_INFO, true ,"popInfo") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEquationUI.setPopInfo(getPopInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationMigrationComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getMigrationComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}