package fr.ifremer.isisfish.ui.input.metier;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MetierUI extends InputContentUI<fr.ifremer.isisfish.entities.Metier> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_METIER_SEASON_INFO_UI_ACTIVE = "metierSeasonInfoUI.active";
    public static final String BINDING_METIER_SEASON_INFO_UI_BEAN = "metierSeasonInfoUI.bean";
    public static final String BINDING_METIER_SEASON_INFO_UI_SENSITIVITY = "metierSeasonInfoUI.sensitivity";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_ACTIVE = "metierSeasonSpeciesUI.active";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_BEAN = "metierSeasonSpeciesUI.bean";
    public static final String BINDING_METIER_SEASON_SPECIES_UI_SENSITIVITY = "metierSeasonSpeciesUI.sensitivity";
    public static final String BINDING_METIER_TAB_UI_ACTIVE = "metierTabUI.active";
    public static final String BINDING_METIER_TAB_UI_BEAN = "metierTabUI.bean";
    public static final String BINDING_METIER_TAB_UI_SENSITIVITY = "metierTabUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUS2/TQBDHJ6FJScOjtGppoYhHewSH8hAS4VFUVDVVCohQqWoubOJNs5WzXnbXrXtBfAQ+Aty5IHHjhDhw5sAF8RUQ4sAVMeskdtKaYpEc7Ghn/r95eGfefIeMknB+i/i+JT2uWYtaK/fW1x/Wtmhd36eqLpnQroT2L5WGdBXydniuNMxWy0Ze6MgLi25LuJzyHnWxDCNK7zpUNSnVGs70K+pKFSqhuegLT3apYVJx1Fc/f6Rf2i9epwF8gdnlsZRz/1JFlQyVIc1sDWMYaZsUHMI3MQ3J+Cbme9ScLTpEqQekRZ/BcxguQ1YQiTANF5KXHDACvS80jM6VuPD0oss1uq+VLmu42JAWa0jaovhWTDWYaloes5hxtFpUMzSsBq+1khABK6thqEYJx+7HqRHN0F91ZJFouEm47VCpYT551OW2pje0a+9i30yLfEvtYMeslUeEUyfyybURT0hNw8k+RzyqUdu4G9exUJEPFWslDYXk+QUKA5kIWWNthwolyuUl3nAN8mZyZCTcwO+6lz7RS68IWsdWmwC3/ydAqO+PkZvDsowdb8ipvjvdbmPHKvYL5s3BbIzhStcg4XQfEefPiuYvGpBUFTLSw2MNU9X9I/sYTe1hndozrAYYWH9Pjn95/+3dUndCcxh7Ita1Z8Hg5AjpCrylzIQ+3h5PTzOnsEpEsYoU6uB2CrbPTExilY4Zk8N4J4zcMnJrmagmIjLDXz98nHz6+RCkl2DEcYm9RIx/CXK6KbELrmP74u5CkNGRncP4HDW5aciiH9vGHh27ZRNNztUYt/Fr3PGxCTMxTQgzqeU+/RqvvF3oNiKFiU3/1T1qRmYDsow7jNNgWXX2UOxyygtFPduN9k3cBkqZ97To3I5LwXM+rtJgvRjrNd8zr+tB0ubfjcSMvKJc4SLaZnp3IJQ5vnoAYSYRoTgwYWFgwkFVnB24imSEg6owhD96KgojFQgAAA==";
    private static final Log log = LogFactory.getLog(MetierUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Metier bean;
    protected MetierHandler handler;
    protected MetierSeasonInfoZoneUI metierSeasonInfoUI;
    protected MetierSeasonInfoSpeciesUI metierSeasonSpeciesUI;
    protected JTabbedPane metierTab;
    protected MetierTabUI metierTabUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            metierTabUI.setLayer(active);
            metierSeasonInfoUI.setLayer(active);
            metierSeasonSpeciesUI.setLayer(active);
        }
        
        @Override
        public void resetChangeModel() {
            metierTabUI.resetChangeModel();
            metierSeasonInfoUI.resetChangeModel();
            metierSeasonSpeciesUI.resetChangeModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierUI() {
        $initialize();
    }

    public MetierUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Metier getBean() {
        return bean;
    }

    public MetierHandler getHandler() {
        return handler;
    }

    public MetierSeasonInfoZoneUI getMetierSeasonInfoUI() {
        return metierSeasonInfoUI;
    }

    public MetierSeasonInfoSpeciesUI getMetierSeasonSpeciesUI() {
        return metierSeasonSpeciesUI;
    }

    public JTabbedPane getMetierTab() {
        return metierTab;
    }

    public MetierTabUI getMetierTabUI() {
        return metierTabUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(metierTab, BorderLayout.CENTER);
    }

    protected void addChildrenToMetierTab() {
        if (!allComponentsCreated) {
            return;
        }
        metierTab.add(metierTabUI);
        metierTab.add(metierSeasonInfoUI);
        metierTab.add(metierSeasonSpeciesUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 0));
        metierTab.setTitleAt(0, t("isisfish.metier.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 1));
        metierTab.setTitleAt(1, t("isisfish.metierSeasonInfoZone.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(metierTab, 2));
        metierTab.setTitleAt(2, t("isisfish.metierSeasonInfoSpecies.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new MetierHandler(this));
    }

    protected void createMetierSeasonInfoUI() {
        $objectMap.put("metierSeasonInfoUI", metierSeasonInfoUI = new MetierSeasonInfoZoneUI(this));
        
        metierSeasonInfoUI.setName("metierSeasonInfoUI");
    }

    protected void createMetierSeasonSpeciesUI() {
        $objectMap.put("metierSeasonSpeciesUI", metierSeasonSpeciesUI = new MetierSeasonInfoSpeciesUI(this));
        
        metierSeasonSpeciesUI.setName("metierSeasonSpeciesUI");
    }

    protected void createMetierTab() {
        $objectMap.put("metierTab", metierTab = new JTabbedPane());
        
        metierTab.setName("metierTab");
    }

    protected void createMetierTabUI() {
        $objectMap.put("metierTabUI", metierTabUI = new MetierTabUI(this));
        
        metierTabUI.setName("metierTabUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToMetierTab();
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createMetierTab();
        createMetierTabUI();
        createMetierSeasonInfoUI();
        createMetierSeasonSpeciesUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.metier.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.metierSeasonInfoZone.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(t("isisfish.metierSeasonInfoSpecies.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_TAB_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierTabUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_INFO_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierSeasonInfoUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_SEASON_SPECIES_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                metierSeasonSpeciesUI.setSensitivity(isSensitivity());
            }
        });
    }

}