package fr.ifremer.isisfish.ui.input.metier;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MetierSeasonInfoZoneUI extends InputContentUI<Metier> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_METIER_SEASON_INFO = "metierSeasonInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_ENABLED = "fieldMetierSeasonZoneComment.enabled";
    public static final String BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_TEXT = "fieldMetierSeasonZoneComment.text";
    public static final String BINDING_IP_ENABLED = "ip.enabled";
    public static final String BINDING_METIER_SEASON_INFO_COMBO_ENABLED = "metierSeasonInfoCombo.enabled";
    public static final String BINDING_METIER_ZONES_ENABLED = "metierZones.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_SEASON_BEAN = "validatorSeason.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHGcNISGRmlTNZVCG/FDLes2RUg0pWljCHXkUITb0tYXZr3P9lT7i5nZZMsBceYCfwLcuSBx44Q4cObABfEvINQDV8SbWXvX627Xq64Pu/G89773ve89v8kPf5Oq4OTVxzQMDR64kjlg7N968OCO+Ri68n0QXc586XESfWYqpNIhi1Z8LiS50Gmp8PowvN7wHN9zwR2L3m6R40I+sUEMAKQk59IRXSHq7di8HfoBH6HGpLJQv3v6T+Vb66vvK4SEPrI7g6VsTItKKpltkQqzJDmJmQ5p3aZuH2lw5vaR75I6a9hUiI+oA5+TL0mtReZ8yhFMkvPFS9YYOj70JVnebLp+IBueK9H9XvOyJNd63GA9Dg7gWzDRY2JgBMxgytFwQDI0HOhXG6jw3Kbb8x5huntN39fIc5LMmkBd7EUWFiZiGC2GIEnQsjOBKslbBQAS/wSqNqCuZQOXZOdFy7kdISSYC4fUZhZFMSW5mGprbDDEEbbLaKvn/dFhgnAidoxSqePTiXmxi6z7cOBZYEvyRi7xRuI6rrpnPcEBUrMSDrnsf0zdcZ/a5l1q2oCNXkvVEHlrm/I8NxlwRX09rx4bsWl+c79FTbAvT+bUp8rpQuy7OtlcHFITO7yaCtSHu16Yjh3l0RxeT9sqON7k4nO0OmJWH6TRxOnmqL2WIht6KwN6aXO/3eWereOwxtMpqokpHbUYFapGCLfRK2ldmJDKbeuZ/Fen5de1v512WO8xsK3x4VVZUUNHb4W0tHchlLc4UBV7bbK7WxndnRX0ECRZSaHsBlJGg7sTO851qduNhG1MWjChhCwLDi6kLZycTU0krmEjWcPJnpzpkCoPbKXuWufZzf0JmqKdvTaxsxWgtv53auWPn//6aW+0qNcx92qm69g9gwvU556PO4Wp1CeiLR1IZtcPqL/dIQsCS+pGl9B6BrH20IzkMJ8eDEOFG7epGCBEtfbnL7+e+uz3Y6SyR47bHrX2qPJvkgU54KiCZ1uhv3NTM3rpaB6fy4obNjFaHHh3vHwd1wvdMJlrYbtuhKjCeoYKMRVz4bd/V9o/3hwpMYPMzjzXPVGj+ojMMddmLuhLa3gfZV5Si76AwPKSeyfrJppR77P+cE3d0c92VqlVvUKV+X4YqNenmrX662FhkBq4aujzYF4rADMr8SeFq+96pMQGlXhbm4GEGy+KqY7NHFZvFmA1j/8SWMCBl8KZxuRSIYS+egzKIORxMEojXCldxXQEdSMwlzmB02ZfQA6ZqwWglnwOPeAcrNJg07R5pzTCu6XVLYbwdQ6H7UII35RGyNPhveI6lELI47BbuhfFEPI4fFCaQzGEPA4fluZQDCGPQ7M0B4XwPzVE3GgsDwAA";
    private static final Log log = LogFactory.getLog(MetierSeasonInfoZoneUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Metier bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldMetierSeasonZoneComment;
    protected MetierSeasonInfoZoneHandler handler;
    protected IntervalPanel ip;
    protected MetierSeasonInfo metierSeasonInfo;
    protected JComboBox<MetierSeasonInfo> metierSeasonInfoCombo;
    protected JList<Zone> metierZones;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Metier> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSeason")
    protected SwingValidator<MetierSeasonInfo> validatorSeason;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MetierSeasonInfoZoneUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MetierSeasonInfoZoneUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MetierSeasonInfoZoneUI() {
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MetierSeasonInfoZoneUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();validator.setChanged(false);validatorSeason.setChanged(false);
    }

    public void doItemStateChanged__on__metierSeasonInfoCombo(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.seasonChanged();
    }

    public void doKeyReleased__on__fieldMetierSeasonZoneComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getMetierSeasonInfo().setSeasonZoneComment(fieldMetierSeasonZoneComment.getText());
    }

    public void doValueChanged__on__metierZones(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.metierZonesChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Metier getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldMetierSeasonZoneComment() {
        return fieldMetierSeasonZoneComment;
    }

    public MetierSeasonInfoZoneHandler getHandler() {
        return handler;
    }

    public IntervalPanel getIp() {
        return ip;
    }

    public MetierSeasonInfo getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public JComboBox<MetierSeasonInfo> getMetierSeasonInfoCombo() {
        return metierSeasonInfoCombo;
    }

    public JList<Zone> getMetierZones() {
        return metierZones;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Metier> getValidator() {
        return validator;
    }

    public SwingValidator<MetierSeasonInfo> getValidatorSeason() {
        return validatorSeason;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Metier bean) {
        Metier oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {
        MetierSeasonInfo oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = metierSeasonInfo;
        firePropertyChange(PROPERTY_METIER_SEASON_INFO, oldValue, metierSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorSeason() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSeason.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldMetierSeasonZoneComment() {
        $objectMap.put("fieldMetierSeasonZoneComment", fieldMetierSeasonZoneComment = new JTextArea());
        
        fieldMetierSeasonZoneComment.setName("fieldMetierSeasonZoneComment");
        fieldMetierSeasonZoneComment.setColumns(15);
        fieldMetierSeasonZoneComment.setLineWrap(true);
        fieldMetierSeasonZoneComment.setWrapStyleWord(true);
        fieldMetierSeasonZoneComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldMetierSeasonZoneComment"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new MetierSeasonInfoZoneHandler(this));
    }

    protected void createIp() {
        $objectMap.put("ip", ip = new IntervalPanel());
        
        ip.setName("ip");
    }

    protected void createMetierSeasonInfo() {
        $objectMap.put("metierSeasonInfo", metierSeasonInfo = null);
    }

    protected void createMetierSeasonInfoCombo() {
        $objectMap.put("metierSeasonInfoCombo", metierSeasonInfoCombo = new JComboBox<MetierSeasonInfo>());
        
        metierSeasonInfoCombo.setName("metierSeasonInfoCombo");
        metierSeasonInfoCombo.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__metierSeasonInfoCombo"));
    }

    protected void createMetierZones() {
        $objectMap.put("metierZones", metierZones = new JList<Zone>());
        
        metierZones.setName("metierZones");
        metierZones.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__metierZones"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Metier.class, "metier"));
    }

    protected void createValidatorSeason() {
        $objectMap.put("validatorSeason", validatorSeason = SwingValidator.newValidator(MetierSeasonInfo.class, "metier"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorSeason();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(metierSeasonInfoCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(ip), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(metierZones));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldMetierSeasonZoneComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        metierSeasonInfoCombo.setRenderer(new MetierSeasonInfoComboRenderer());
        $JScrollPane0.setMinimumSize(new Dimension(0,0));
        $JScrollPane0.setPreferredSize(new Dimension(0,0));
        $JScrollPane1.setMinimumSize(new Dimension(0,0));
        $JScrollPane1.setPreferredSize(new Dimension(0,0));
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createMetierSeasonInfo();
        createHandler();
        createValidator();
        createValidatorSeason();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.metierSeasonInfoZone.selectSeason"));
        createMetierSeasonInfoCombo();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.metierSeasonInfoZone.season"));
        createIp();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.common.zone"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMetierZones();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.metierSeasonInfoZone.comments"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFieldMetierSeasonZoneComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_SEASON_BEAN, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validatorSeason.setBean(getMetierSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setChanged(validator.isChanged() || validatorSeason.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setValid(validator.isValid() && validatorSeason.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_METIER_SEASON_INFO_COMBO_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    metierSeasonInfoCombo.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IP_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                ip.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_METIER_ZONES_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                metierZones.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldMetierSeasonZoneComment.setEnabled(getMetierSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_METIER_SEASON_ZONE_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("metierSeasonInfo", this);
                if (getMetierSeasonInfo() != null) {
                    getMetierSeasonInfo().addPropertyChangeListener("seasonZoneComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getMetierSeasonInfo() != null) {
                    SwingUtil.setText(fieldMetierSeasonZoneComment, jaxx.runtime.SwingUtil.getStringValue(getMetierSeasonInfo().getSeasonZoneComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("metierSeasonInfo", this);
                if (getMetierSeasonInfo() != null) {
                    getMetierSeasonInfo().removePropertyChangeListener("seasonZoneComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    create.setEnabled(!changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"metierSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(getMetierSeasonInfo() != null);
            }
        });
    }

}