/*
 * #%L
 * IsisFish
 * 
 * $Id: SaveVerifier.java 4227 2015-05-20 12:09:09Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/SaveVerifier.java $
 * %%
 * Copyright (C) 2009 - 2015 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui;

import javax.swing.JOptionPane;

/**
 * Isis interface modification verifier.
 * 
 * Check that unsaved datas need to be saved.
 * 
 * @author letellier
 * 
 * @version $Revision: 4227 $
 *
 * Last update: $Date: 2015-05-20 14:09:09 +0200 (mer., 20 mai 2015) $
 * by : $Author: echatellier $
 */
public interface SaveVerifier {

    public static final int YES_OPTION = JOptionPane.YES_OPTION;
    public static final int NO_OPTION = JOptionPane.NO_OPTION;
    public static final int CANCEL_OPTION = JOptionPane.CANCEL_OPTION;

    /**
     * Tell verifier to check for unsaved modification.
     * 
     * @return user int response
     * @see #YES_OPTION
     * @see #NO_OPTION
     * @see #CANCEL_OPTION
     */
    public int checkEdit();
}
