/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.check;

import fr.ifremer.isisfish.ui.input.check.CheckResult;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class CheckResultTableModel
extends AbstractTableModel
implements Comparator<Object[]> {
    private static final long serialVersionUID = 328398134761266970L;
    protected CheckResult checkResult;
    protected List<Object[]> data;
    protected int sortedBy = -1;
    protected boolean ascending = true;
    String[] titles = new String[]{"Class", "Object", "Level", "Message"};

    public CheckResultTableModel(CheckResult checkResult) {
        this.setCheckResult(checkResult);
    }

    public void setCheckResult(CheckResult checkResult) {
        this.checkResult = checkResult;
        this.computeData();
    }

    protected void computeData() {
        this.data = new ArrayList<Object[]>();
        for (TopiaEntity topiaEntity : this.checkResult.order) {
            String type = TopiaId.getClassNameAsString((String)topiaEntity.getTopiaId());
            this.addOneData(topiaEntity, type, "error", this.checkResult.error.get(topiaEntity), this.data);
            this.addOneData(topiaEntity, type, "warning", this.checkResult.warning.get(topiaEntity), this.data);
            this.addOneData(topiaEntity, type, "info", this.checkResult.info.get(topiaEntity), this.data);
        }
        this.fireTableDataChanged();
    }

    protected void addOneData(Object o, String type, String level, List<String> list, Collection<Object[]> result) {
        if (list != null && list.size() != 0) {
            for (String message : list) {
                result.add(new Object[]{type, o, level, message});
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.titles[column];
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object[] rowData = this.data.get(row);
        return rowData[column];
    }

    public void setSortedBy(int column) {
        if (column == this.sortedBy) {
            this.ascending = !this.ascending;
        } else {
            this.sortedBy = column;
            this.ascending = true;
        }
        Collections.sort(this.data, this);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(Object[] data1, Object[] data2) {
        int result = data1[this.sortedBy].toString().compareTo(data2[this.sortedBy].toString());
        return this.ascending ? result : -result;
    }

    public void addMouseListenerToHeaderInTable(final JTable table) {
        table.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    CheckResultTableModel.this.setSortedBy(column);
                }
            }
        };
        JTableHeader th = table.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

