/*
 * #%L
 * IsisFish
 * 
 * $Id: IsisAction.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import java.awt.event.ActionEvent;

public abstract class IsisAction extends AbstractAction {
    /**
     * flag to say if something has been done in this action (is init in
     * {@link #prepare()} method)
     */
    protected boolean used;
    /**
     * dialog source of the action (of <code>null</code> if none)
     */
    protected JDialog dialog;

    private static final long serialVersionUID = -968662451138199001L;

    protected IsisAction() {
        this(null);
    }

    protected IsisAction(JDialog dialog) {
        this.dialog = dialog;
    }


    public void actionPerformed(ActionEvent e) {

        try {
            // just prepare action and set used field value
            used = prepare();

            // perform action if there is something to do
            if (used) {
                perform(e);
            }
        } finally {
            //TODO Fix lock between few dialog
            // after action perfored
            finish();
        }
    }
    /**
     * Prepare data for action, and find out if there is really something to
     * do here.
     *
     * @return <code>true</code> if there is something to do here,
     *         <code>false</code> otherwise
     */
    protected abstract boolean prepare();

    /**
     * perform safelly action after {@link #prepare()} was invoked
     * This method is only called if used was <code>true</code>
     *
     * @param e event source
     */
    protected abstract void perform(ActionEvent e);

    /**
     * called inside {@link #actionPerformed(java.awt.event.ActionEvent)} after
     * {@link #perform(java.awt.event.ActionEvent)} was invoked (so can't
     * be come here is nothing was to be done in this action.
     */
    protected void finish() {
        if (dialog != null && needDispose()) {
            dialog.dispose();
        }
    }

    /**
     * @return <code>true</code> if we have to dispose dialog,
     *         <code>false</code> otherwise
     */
    protected boolean needDispose() {
        return used;
    }

    /**
     * @return <code>true</code> if something was done in the action performed,
     *         <code>false</code> otherwise
     */
    public boolean isUsed() {
        return used;
    }
}
