package fr.ifremer.isisfish.ui.simulator;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class OptimizationUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVQU8TQRgdqgWKKEgFARFRMTEetqIkHjCKgAikgrGaqL047Q50zHRnnZmFVRPjT/An6N2LiTdPxoNnD16Mf8EYD16N38yW3S5d22p72LYz3/e+995MX998R2kp0MlH2Pct4TmKVom1du3evY3SI1JWS0SWBXUVFyh4daVQqogO2OG6VOh0Ma/bc7X23CKvutwhTl33XB71SfWEEVkhRCl0PN5RljJXCLfnfNcTu6ghqSTUVz9/pF7aL16nEPJdYHcEpEy16oqU7M+jFLUVGoJJ2zjHsLMFNAR1toDvQb22yLCU67hKHqPnqCePul0sAEyhU+1LNhim33cV6pm+g0uMnFcotyksuilIlcC7pHKTyorlUUvSqscwIFgbLoDTp1hR7txddV2D0g0YFezYjAiFZv8JYyVoi4B6p9fyuEQYsBnScn1L7oB6K1jVRZmwdnyTEmYH14Juk5tEVbhdIAy+KjQc6wY3SnyB+3GAg9NrhbLgjN3CjtZ/NNYTbcW7xoyUPWNvYYGrezkbX3XXcIO+Gf39cBz4eKCnzp56SbroSBP+BvFovGAioNqAaNjqmnH9ONHA7kICu9iwCwnDBgz9677LhcpTCWdwOH6CsKZLz0S3Jrh5MwqNxn4iQUPoXjRiENu1AXLBU4o7CmVjM4JVXX0ubMrCZeTbJNant3LxsqEyI1i0qoq5cDHBhRFiEDZKkohtY3mow5g9G1aeaKgMDlqfErcJU2iyXpu2L14AvxqBjsWcg9iyotiKcqWriNLCg2WwutiYdLdhK8i40T0ZpwHN7u+R7Jf3394t7wZbFmYPJ5bW5TIEjiu4C7lA9eiBINU8RVnuJnbniigjjSIT2hMJxAq1bSAH88x9snS7tYJlBSDSPV8/fBx5+HkfSi2jPsaxvYx1/SrKqIoAFzizfffqvGHUv9MLz0HNTaH9ivhwRYcuU4dRh0xhBTFb8hS54oMNEwk2hFxKmU+/soW387tWdAG1sb+WR3akH6DuYJpJ+VqAJ6b6AVcSz+ZRUCdFd5d+H3Rr4TlvnktJWtPV4D4dumxjhadK1LHhRoFQ3bFiFOhPawYw2wZgL/zl2EQQoSs2/h8nI/jOCqFbFRMMN5KBxloC6eXlJggTbSGsNxEz2RbCnY4R7jdRcapjH6bbOJL+MmHsduvjPduxp60R4B+CODo97SairI5taQ/hWROEmY45tIfQjMPFjjm0h9DsSC91fMk1wh9M6JbeAgwAAA==";
    private static final Log log = LogFactory.getLog(OptimizationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addExportsButton;
    protected JButton clearExportsButton;
    protected ListSelectionModel exportObservationSelectionModel;
    protected JTable exportObservationTable;
    protected JList<String> fieldExportList;
    protected JComboBox<String> fieldObjectiveMethodSelect;
    protected JComboBox<String> fieldOptimizationMethodSelect;
    protected OptimizationHandler handler;
    protected JButton removeExportsButton;
    protected JTable simulObjectiveMethodParam;
    protected JTable simulOptimizationMethodParam;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private OptimizationUI $Table0 = this;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /*protected void $afterCompleteSetup() {
            handler.init(this);
          }*/
    
          // application will be refreshed by regionStorage change
          protected void regionStorageChanged() {
              handler.init(this);
          }
    
          public void refresh() {
            //handler.refresh(this);
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OptimizationUI() {
        $initialize();
    }

    public OptimizationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addExportsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addExports(this);
    }

    public void doActionPerformed__on__clearExportsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.clearExports(this);
    }

    public void doActionPerformed__on__fieldObjectiveMethodSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.objectiveChanged(this);
    }

    public void doActionPerformed__on__fieldOptimizationMethodSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.optimizationChanged(this);
    }

    public void doActionPerformed__on__removeExportsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeExports(this);
    }

    public void doValueChanged__on__exportObservationSelectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeExportsButton.setEnabled(!exportObservationSelectionModel.isSelectionEmpty());clearExportsButton.setEnabled(exportObservationTable.getModel().getRowCount() > 0);
    }

    public void doValueChanged__on__fieldExportList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addExportsButton.setEnabled(fieldExportList.getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddExportsButton() {
        return addExportsButton;
    }

    public JButton getClearExportsButton() {
        return clearExportsButton;
    }

    public ListSelectionModel getExportObservationSelectionModel() {
        return exportObservationSelectionModel;
    }

    public JTable getExportObservationTable() {
        return exportObservationTable;
    }

    public JList<String> getFieldExportList() {
        return fieldExportList;
    }

    public JComboBox<String> getFieldObjectiveMethodSelect() {
        return fieldObjectiveMethodSelect;
    }

    public JComboBox<String> getFieldOptimizationMethodSelect() {
        return fieldOptimizationMethodSelect;
    }

    public OptimizationHandler getHandler() {
        return handler;
    }

    public JButton getRemoveExportsButton() {
        return removeExportsButton;
    }

    public JTable getSimulObjectiveMethodParam() {
        return simulObjectiveMethodParam;
    }

    public JTable getSimulOptimizationMethodParam() {
        return simulOptimizationMethodParam;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(OptimizationHandler handler) {
        OptimizationHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddExportsButton() {
        $objectMap.put("addExportsButton", addExportsButton = new JButton());
        
        addExportsButton.setName("addExportsButton");
        addExportsButton.setEnabled(false);
        addExportsButton.setText(t("isisfish.common.add"));
        addExportsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addExportsButton"));
    }

    protected void createClearExportsButton() {
        $objectMap.put("clearExportsButton", clearExportsButton = new JButton());
        
        clearExportsButton.setName("clearExportsButton");
        clearExportsButton.setEnabled(false);
        clearExportsButton.setText(t("isisfish.common.clear"));
        clearExportsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__clearExportsButton"));
    }

    protected void createExportObservationSelectionModel() {
        $objectMap.put("exportObservationSelectionModel", exportObservationSelectionModel = exportObservationTable.getSelectionModel());
        
        exportObservationSelectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__exportObservationSelectionModel"));
    }

    protected void createExportObservationTable() {
        $objectMap.put("exportObservationTable", exportObservationTable = new JTable());
        
        exportObservationTable.setName("exportObservationTable");
        exportObservationTable.setRowHeight(24);
    }

    protected void createFieldExportList() {
        $objectMap.put("fieldExportList", fieldExportList = new JList<String>());
        
        fieldExportList.setName("fieldExportList");
        fieldExportList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__fieldExportList"));
    }

    protected void createFieldObjectiveMethodSelect() {
        $objectMap.put("fieldObjectiveMethodSelect", fieldObjectiveMethodSelect = new JComboBox<String>());
        
        fieldObjectiveMethodSelect.setName("fieldObjectiveMethodSelect");
        fieldObjectiveMethodSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldObjectiveMethodSelect"));
    }

    protected void createFieldOptimizationMethodSelect() {
        $objectMap.put("fieldOptimizationMethodSelect", fieldOptimizationMethodSelect = new JComboBox<String>());
        
        fieldOptimizationMethodSelect.setName("fieldOptimizationMethodSelect");
        fieldOptimizationMethodSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldOptimizationMethodSelect"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new OptimizationHandler());
    }

    protected void createRemoveExportsButton() {
        $objectMap.put("removeExportsButton", removeExportsButton = new JButton());
        
        removeExportsButton.setName("removeExportsButton");
        removeExportsButton.setEnabled(false);
        removeExportsButton.setText(t("isisfish.common.remove"));
        removeExportsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeExportsButton"));
    }

    protected void createSimulObjectiveMethodParam() {
        $objectMap.put("simulObjectiveMethodParam", simulObjectiveMethodParam = new JTable());
        
        simulObjectiveMethodParam.setName("simulObjectiveMethodParam");
        simulObjectiveMethodParam.setRowHeight(24);
    }

    protected void createSimulOptimizationMethodParam() {
        $objectMap.put("simulOptimizationMethodParam", simulOptimizationMethodParam = new JTable());
        
        simulOptimizationMethodParam.setName("simulOptimizationMethodParam");
        simulOptimizationMethodParam.setRowHeight(24);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldObjectiveMethodSelect, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(fieldOptimizationMethodSelect, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel2, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane2, new GridBagConstraints(0, 5, 1, 1, 0.2, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table1, new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane3, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(simulObjectiveMethodParam);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(simulOptimizationMethodParam);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(fieldExportList);
        // inline complete setup of $Table1
        $Table1.add(addExportsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(removeExportsButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(clearExportsButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(exportObservationTable);
        
        // apply 7 property setters
        fieldObjectiveMethodSelect.setModel(handler.getObjectiveComboModel());
        fieldObjectiveMethodSelect.setRenderer(new fr.ifremer.isisfish.ui.models.optimization.ObjectiveComboRenderer());
        fieldOptimizationMethodSelect.setModel(handler.getOptimizationComboModel());
        fieldOptimizationMethodSelect.setRenderer(new fr.ifremer.isisfish.ui.models.optimization.OptimizationComboRenderer());
        fieldExportList.setCellRenderer(new fr.ifremer.isisfish.ui.models.export.ExportNameListRenderer());
        fieldExportList.setModel(handler.getExportListModel());
        exportObservationTable.setModel(handler.getExportObservationTableModel(this));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.optimization.objective"));
        createFieldObjectiveMethodSelect();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSimulObjectiveMethodParam();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.optimization.method"));
        createFieldOptimizationMethodSelect();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSimulOptimizationMethodParam();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.optimization.exports"));
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createFieldExportList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createAddExportsButton();
        createRemoveExportsButton();
        createClearExportsButton();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createExportObservationTable();
        createExportObservationSelectionModel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}