package fr.ifremer.isisfish.ui.input;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.model.TopiaEntityListModel;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ZoneBasicsUI extends InputContentUI<Zone> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_ZONE_MAP = "zoneMap";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_ZONE_COMMENT_ENABLED = "fieldZoneComment.enabled";
    public static final String BINDING_FIELD_ZONE_COMMENT_TEXT = "fieldZoneComment.text";
    public static final String BINDING_FIELD_ZONE_NAME_ENABLED = "fieldZoneName.enabled";
    public static final String BINDING_FIELD_ZONE_NAME_TEXT = "fieldZoneName.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_ZONE_CELLS_ENABLED = "zoneCells.enabled";
    public static final String BINDING_ZONE_MAP_FISHERY_REGION = "zoneMap.fisheryRegion";
    public static final String BINDING_ZONE_MAP_SELECTED_CELLS = "zoneMap.selectedCells";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WQW/cRBSebJNst2kgJCQESEXaLEJQyZtWCAGJSpuUFbvalKqboqorAWN7NjvV7MwwM04dDoifwE+AOxckbpwQB84cuCD+AkIcuKK+8e7aceI4lswebO+8933zvTczn/39X2hGK3T1CQ5DRwXc0CFx2ncePfrYfUI8c5doT1FphEKj31QFVXpozo/HtUEbvY6FN8bwxq4YSsEJP4be6qBL2hwxogeEGIOupBGe1o1uHN4KZaAmrLGoLNZv//m78o3/9XcVhEIJ6pahlPXzUEkl0x1Uob5BizDTIW4wzA9AhqL8APTO27FdhrW+h4fkC/QVqnbQrMQKyAy6VrzkiCPCh9KghXqLy8DsCm4g/WFr06A3+8qhfUWGBO6a6j7VAyegDrWJzmPg3cGaevphS8qIaNagaZdgbtDVLCjwUkOJjqAJpHaIGfUxSDPoeqpJccDRT6F4p2uvn0wGj08q/CNol+1MOM5t38ecsCTncr3dlYwaOwy1raRy44hNXowx1fo+dplNX03pGqGimM1cjgEX6+0OdgnbPCkmGrVJq3HufJ8S5ttW2HU8qWifhKZpE9KgyQQ37P8r6diclpZtlzAGm/+ldIGeEoxNKkwwtS8TxAtpxVQbm7Rxau6bGXPP149NsWkHX08nLMTVwpYcRlt1+VTBdxTBNv96srIaH0JvllKpO4Exgqf5Zz3MvVGLb56MAKshWRGfMJIZuTDE0j6+mF7equ3WHobTspG1vwHktOAPZOzAKbCg95LVGWNbvC8Mqnti6Lgud4QkPMLBsBpiQwW/C6oO7AYfEyj0amr3gSk5iSklrjHVQzMqgGHYrr3TPvYAQiMHWz3hYJYwiv63svT7T3/+2JzY1isw93Jm6jHXBTuRCspQ9mgb9PzIswJDWQPK3eqhmoaCvJElr2UI647DIA7mi3ahY+HOR1gPgGKm+sfPv6x8/tsFVGmiS0xgv4ltfgvVzEBBFwTzQ/nB7UjR5acX4bpgtYEWnx5Sn6iO8KLOwqncppxRTtaxAT91A0NuhdCRtYyOxLLc2q//LnV/uD3pyhSofPnM9KQzM4/R7Gi2yM7HTp1p33NSk8AXiSNnefSUva/IsaU1o2s7q+xF2Gn7IvAGH4YSc39iU3thYG/3ohLs0/3CjHNCUTizURNLUlUJt4Lg7fbcNtg4Xncp9+FY38qmXCtAOW3AO3Jknc9hhz+1l8+yGV4rxOCXZsjTcK24hjP6UIwhT8MbpRneKl1FMYY8DU7p1SzGkKfhRuk+FGPI0/B2aQ3FGPI0vFNaQzGGPA3vltZwPgN8bTB8JAKTo+P9Aizz9kuDqKMH5GDsxWeQbRchG72ZiR99Af4/ZKBqT/jkHLJnIE38oN8NAAA=";
    private static final Log log = LogFactory.getLog(ZoneBasicsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Zone bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldZoneComment;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldZoneName")
    protected JTextField fieldZoneName;
    protected JPanel map;
    protected JButton save;
    @ValidatorField( validatorId = "validator",  propertyName = "cell",  editorName = "spZoneCells")
    protected JScrollPane spZoneCells;
    @Validator( validatorId = "validator")
    protected SwingValidator<Zone> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JList zoneCells;
    protected IsisMapBean zoneMap;
    protected InformationDelegator zoneMapInfo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ZoneBasicsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
    
        //zoneMap.init(zoneMapInfo);
        new OpenMapEvents(zoneMap, new SelectMouseMode(false), CellSelectionLayer.MULT_SELECTION) {
            @Override
            public boolean mouseClicked(MouseEvent e) {
                boolean result = false;
                if (getBean() != null) { // impossible de desactiver la carte :(
                    getBean().setCell(zoneMap.getSelectedCells());
                    setZoneCells();
                }
                return result;
            }
        };
    
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldZoneName.setText("");
                    fieldZoneComment.setText("");
                    zoneMap.setSelectedCells();
                }
                if (evt.getNewValue() != null) {
                    setZoneCells();
                }
            }
        });
    }
    
    protected void setZoneCells() {
        if (getBean() != null) {
            List<Cell> cells = getFisheryRegion().getCell();
            TopiaEntityListModel model = new TopiaEntityListModel(cells);
            zoneCells.setModel(model);
            if (getBean().getCell() != null) {
                for (Cell selectedCell : getBean().getCell()) {
                    int index = cells.indexOf(selectedCell);
                    zoneCells.addSelectionInterval(index, index);
                }
            }
        }
    }
    
    protected void zoneCellsChange(ListSelectionEvent event) {
        // sans ca, ca boucle (modification depuis la carte)
        if (event.getValueIsAdjusting()) {
            // pas a faie dans le cas d'une AS
            if (isActive()) {
                java.util.List<Cell> cells = new ArrayList<Cell>();
                for (Object o : zoneCells.getSelectedValues()) {
                    cells.add((Cell) o);
                }
                getBean().setCell(cells);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ZoneBasicsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ZoneBasicsUI() {
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ZoneBasicsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ZoneBasicsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Zone.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldZoneComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldZoneComment.getText());
    }

    public void doKeyReleased__on__fieldZoneName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldZoneName.getText());
    }

    public void doValueChanged__on__zoneCells(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        zoneCellsChange(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Zone getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldZoneComment() {
        return fieldZoneComment;
    }

    public JTextField getFieldZoneName() {
        return fieldZoneName;
    }

    public JPanel getMap() {
        return map;
    }

    public JButton getSave() {
        return save;
    }

    public JScrollPane getSpZoneCells() {
        return spZoneCells;
    }

    public SwingValidator<Zone> getValidator() {
        return validator;
    }

    public JList getZoneCells() {
        return zoneCells;
    }

    public IsisMapBean getZoneMap() {
        return zoneMap;
    }

    public InformationDelegator getZoneMapInfo() {
        return zoneMapInfo;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Zone bean) {
        Zone oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setZoneMap(IsisMapBean zoneMap) {
        IsisMapBean oldValue = this.zoneMap;
        this.zoneMap = zoneMap;
        firePropertyChange(PROPERTY_ZONE_MAP, oldValue, zoneMap);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JSplitPane0);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(SwingUtil.boxComponentWithJxLayer(zoneMap), BorderLayout.CENTER);
        map.add(zoneMapInfo, BorderLayout.SOUTH);
    }

    protected void addChildrenToSpZoneCells() {
        if (!allComponentsCreated) {
            return;
        }
        spZoneCells.getViewport().add(SwingUtil.boxComponentWithJxLayer(zoneCells));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldZoneComment() {
        $objectMap.put("fieldZoneComment", fieldZoneComment = new JTextArea());
        
        fieldZoneComment.setName("fieldZoneComment");
        fieldZoneComment.setColumns(15);
        fieldZoneComment.setLineWrap(true);
        fieldZoneComment.setWrapStyleWord(true);
        fieldZoneComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldZoneComment"));
    }

    protected void createFieldZoneName() {
        $objectMap.put("fieldZoneName", fieldZoneName = new JTextField());
        
        fieldZoneName.setName("fieldZoneName");
        fieldZoneName.setColumns(15);
        fieldZoneName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldZoneName"));
    }

    protected void createMap() {
        $objectMap.put("map", map = new JPanel());
        
        map.setName("map");
        map.setLayout(new BorderLayout());
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSpZoneCells() {
        $objectMap.put("spZoneCells", spZoneCells = new JScrollPane());
        
        spZoneCells.setName("spZoneCells");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Zone.class, null));
    }

    protected void createZoneCells() {
        $objectMap.put("zoneCells", zoneCells = new JList());
        
        zoneCells.setName("zoneCells");
        zoneCells.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__zoneCells"));
    }

    protected void createZoneMap() {
        $objectMap.put("zoneMap", zoneMap = new fr.ifremer.isisfish.map.IsisMapBean());
        
        zoneMap.setName("zoneMap");
    }

    protected void createZoneMapInfo() {
        $objectMap.put("zoneMapInfo", zoneMapInfo = new InformationDelegator());
        
        zoneMapInfo.setName("zoneMapInfo");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add(map, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldZoneName)), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(spZoneCells), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSpZoneCells();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldZoneComment));
        addChildrenToMap();
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        zoneMap.setSelectionMode(fr.ifremer.isisfish.map.CellSelectionLayer.MULT_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createValidator();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.zone.name"));
        createFieldZoneName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.zone.cells"));
        createSpZoneCells();
        createZoneCells();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.zone.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldZoneComment();
        createSave();
        createCancel();
        createCreate();
        createDelete();
        createMap();
        createZoneMap();
        createZoneMapInfo();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldZoneName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldZoneName, jaxx.runtime.SwingUtil.getStringValue(getBean().getName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_CELLS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                zoneCells.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldZoneComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_ZONE_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldZoneComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ZONE_MAP_FISHERY_REGION, true ,"fisheryRegion") {
        
            @Override
            public void processDataBinding() {
                zoneMap.setFisheryRegion(getFisheryRegion());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ZONE_MAP_SELECTED_CELLS, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("cell", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    zoneMap.setSelectedCells(getBean()==null?null:bean.getCell());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("cell", this);
                }
            }
        });
    }

}