package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Mon Jun 16 12:41:24 CEST 2014")
public abstract class EffortDescriptionAbstract extends TopiaEntityAbstract implements EffortDescription {

    /**
     * <p>Nombre d'op&eacute;ration de p&ecirc;che par jour</p>
     * 
     * Nom de l'attribut en BD : fishingOperation
     */
    protected int fishingOperation;

    /**
     * Nom de l'attribut en BD : fishingOperationDuration
     */
    protected TimeUnit fishingOperationDuration;

    /**
     * Nom de l'attribut en BD : gearsNumberPerOperation
     */
    protected int gearsNumberPerOperation;

    /**
     * <p>Taille de l'&eacute;quipage pour le m&eacute;tier. Ne peut-&ecirc;tre inf&eacute;rieur &agrave; VesselType.minCrewSize.</p>
     * 
     * Nom de l'attribut en BD : crewSize
     */
    protected int crewSize;

    /**
     * <p>Co&ucirc;t de fonctionnement li&eacute; &agrave; une op&eacute;ration de p&ecirc;che: carburant, huile, app&acirc;t, glace (hors transport sur zone)</p>
     * 
     * Nom de l'attribut en BD : unitCostOfFishing
     */
    protected double unitCostOfFishing;

    /**
     * <p>Salaire fixe pour l'ensemble de l'&eacute;quipage pour un mois</p>
     * 
     * Nom de l'attribut en BD : fixedCrewSalary
     */
    protected double fixedCrewSalary;

    /**
     * <p>Taux de part de l'&eacute;quipage</p>
     * 
     * Nom de l'attribut en BD : crewShareRate
     */
    protected double crewShareRate;

    /**
     * <p>Frais de vivres pour l'ensemble de l'&eacute;quipage par jour.</p>
     * 
     * Nom de l'attribut en BD : crewFoodCost
     */
    protected double crewFoodCost;

    /**
     * <p>Co&ucirc;t de maintenance et de r&eacute;paration par jour d'utilisation</p>
     * 
     * Nom de l'attribut en BD : repairAndMaintenanceGearCost
     */
    protected double repairAndMaintenanceGearCost;

    /**
     * <p>autres co&ucirc;ts par jour</p>
     * 
     * Nom de l'attribut en BD : otherRunningCost
     */
    protected double otherRunningCost;

    /**
     * Nom de l'attribut en BD : landingCosts
     */
    protected double landingCosts;

    /**
     * Nom de l'attribut en BD : setOfVessels
     */
    protected SetOfVessels setOfVessels;

    /**
     * Nom de l'attribut en BD : possibleMetiers
     */
    protected Metier possibleMetiers;

    private static final long serialVersionUID = 7147268023248041013L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(EffortDescription.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_FISHING_OPERATION, int.class, fishingOperation);
        visitor.visit(this, PROPERTY_FISHING_OPERATION_DURATION, TimeUnit.class, fishingOperationDuration);
        visitor.visit(this, PROPERTY_GEARS_NUMBER_PER_OPERATION, int.class, gearsNumberPerOperation);
        visitor.visit(this, PROPERTY_CREW_SIZE, int.class, crewSize);
        visitor.visit(this, PROPERTY_UNIT_COST_OF_FISHING, double.class, unitCostOfFishing);
        visitor.visit(this, PROPERTY_FIXED_CREW_SALARY, double.class, fixedCrewSalary);
        visitor.visit(this, PROPERTY_CREW_SHARE_RATE, double.class, crewShareRate);
        visitor.visit(this, PROPERTY_CREW_FOOD_COST, double.class, crewFoodCost);
        visitor.visit(this, PROPERTY_REPAIR_AND_MAINTENANCE_GEAR_COST, double.class, repairAndMaintenanceGearCost);
        visitor.visit(this, PROPERTY_OTHER_RUNNING_COST, double.class, otherRunningCost);
        visitor.visit(this, PROPERTY_LANDING_COSTS, double.class, landingCosts);
        visitor.visit(this, PROPERTY_SET_OF_VESSELS, SetOfVessels.class, setOfVessels);
        visitor.visit(this, PROPERTY_POSSIBLE_METIERS, Metier.class, possibleMetiers);
        visitor.end(this);
    }

    @Override
    public void setFishingOperation(int fishingOperation) {
        int oldValue = this.fishingOperation;
        fireOnPreWrite(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
        this.fishingOperation = fishingOperation;
        fireOnPostWrite(PROPERTY_FISHING_OPERATION, oldValue, fishingOperation);
    }

    @Override
    public int getFishingOperation() {
        int result = this.fishingOperation;

        return result;
    }

    @Override
    public void setFishingOperationDuration(TimeUnit fishingOperationDuration) {
        TimeUnit oldValue = this.fishingOperationDuration;
        fireOnPreWrite(PROPERTY_FISHING_OPERATION_DURATION, oldValue, fishingOperationDuration);
        this.fishingOperationDuration = fishingOperationDuration;
        fireOnPostWrite(PROPERTY_FISHING_OPERATION_DURATION, oldValue, fishingOperationDuration);
    }

    @Override
    public TimeUnit getFishingOperationDuration() {
        TimeUnit result = this.fishingOperationDuration;

        return result;
    }

    @Override
    public void setGearsNumberPerOperation(int gearsNumberPerOperation) {
        int oldValue = this.gearsNumberPerOperation;
        fireOnPreWrite(PROPERTY_GEARS_NUMBER_PER_OPERATION, oldValue, gearsNumberPerOperation);
        this.gearsNumberPerOperation = gearsNumberPerOperation;
        fireOnPostWrite(PROPERTY_GEARS_NUMBER_PER_OPERATION, oldValue, gearsNumberPerOperation);
    }

    @Override
    public int getGearsNumberPerOperation() {
        int result = this.gearsNumberPerOperation;

        return result;
    }

    @Override
    public void setCrewSize(int crewSize) {
        int oldValue = this.crewSize;
        fireOnPreWrite(PROPERTY_CREW_SIZE, oldValue, crewSize);
        this.crewSize = crewSize;
        fireOnPostWrite(PROPERTY_CREW_SIZE, oldValue, crewSize);
    }

    @Override
    public int getCrewSize() {
        int result = this.crewSize;

        return result;
    }

    @Override
    public void setUnitCostOfFishing(double unitCostOfFishing) {
        double oldValue = this.unitCostOfFishing;
        fireOnPreWrite(PROPERTY_UNIT_COST_OF_FISHING, oldValue, unitCostOfFishing);
        this.unitCostOfFishing = unitCostOfFishing;
        fireOnPostWrite(PROPERTY_UNIT_COST_OF_FISHING, oldValue, unitCostOfFishing);
    }

    @Override
    public double getUnitCostOfFishing() {
        double result = this.unitCostOfFishing;

        return result;
    }

    @Override
    public void setFixedCrewSalary(double fixedCrewSalary) {
        double oldValue = this.fixedCrewSalary;
        fireOnPreWrite(PROPERTY_FIXED_CREW_SALARY, oldValue, fixedCrewSalary);
        this.fixedCrewSalary = fixedCrewSalary;
        fireOnPostWrite(PROPERTY_FIXED_CREW_SALARY, oldValue, fixedCrewSalary);
    }

    @Override
    public double getFixedCrewSalary() {
        double result = this.fixedCrewSalary;

        return result;
    }

    @Override
    public void setCrewShareRate(double crewShareRate) {
        double oldValue = this.crewShareRate;
        fireOnPreWrite(PROPERTY_CREW_SHARE_RATE, oldValue, crewShareRate);
        this.crewShareRate = crewShareRate;
        fireOnPostWrite(PROPERTY_CREW_SHARE_RATE, oldValue, crewShareRate);
    }

    @Override
    public double getCrewShareRate() {
        double result = this.crewShareRate;

        return result;
    }

    @Override
    public void setCrewFoodCost(double crewFoodCost) {
        double oldValue = this.crewFoodCost;
        fireOnPreWrite(PROPERTY_CREW_FOOD_COST, oldValue, crewFoodCost);
        this.crewFoodCost = crewFoodCost;
        fireOnPostWrite(PROPERTY_CREW_FOOD_COST, oldValue, crewFoodCost);
    }

    @Override
    public double getCrewFoodCost() {
        double result = this.crewFoodCost;

        return result;
    }

    @Override
    public void setRepairAndMaintenanceGearCost(double repairAndMaintenanceGearCost) {
        double oldValue = this.repairAndMaintenanceGearCost;
        fireOnPreWrite(PROPERTY_REPAIR_AND_MAINTENANCE_GEAR_COST, oldValue, repairAndMaintenanceGearCost);
        this.repairAndMaintenanceGearCost = repairAndMaintenanceGearCost;
        fireOnPostWrite(PROPERTY_REPAIR_AND_MAINTENANCE_GEAR_COST, oldValue, repairAndMaintenanceGearCost);
    }

    @Override
    public double getRepairAndMaintenanceGearCost() {
        double result = this.repairAndMaintenanceGearCost;

        return result;
    }

    @Override
    public void setOtherRunningCost(double otherRunningCost) {
        double oldValue = this.otherRunningCost;
        fireOnPreWrite(PROPERTY_OTHER_RUNNING_COST, oldValue, otherRunningCost);
        this.otherRunningCost = otherRunningCost;
        fireOnPostWrite(PROPERTY_OTHER_RUNNING_COST, oldValue, otherRunningCost);
    }

    @Override
    public double getOtherRunningCost() {
        double result = this.otherRunningCost;

        return result;
    }

    @Override
    public void setLandingCosts(double landingCosts) {
        double oldValue = this.landingCosts;
        fireOnPreWrite(PROPERTY_LANDING_COSTS, oldValue, landingCosts);
        this.landingCosts = landingCosts;
        fireOnPostWrite(PROPERTY_LANDING_COSTS, oldValue, landingCosts);
    }

    @Override
    public double getLandingCosts() {
        double result = this.landingCosts;

        return result;
    }

    @Override
    public void setSetOfVessels(SetOfVessels setOfVessels) {
        SetOfVessels oldValue = this.setOfVessels;
        fireOnPreWrite(PROPERTY_SET_OF_VESSELS, oldValue, setOfVessels);
        this.setOfVessels = setOfVessels;
        fireOnPostWrite(PROPERTY_SET_OF_VESSELS, oldValue, setOfVessels);
    }

    @Override
    public SetOfVessels getSetOfVessels() {
        SetOfVessels result = this.setOfVessels;

        return result;
    }

    @Override
    public void setPossibleMetiers(Metier possibleMetiers) {
        Metier oldValue = this.possibleMetiers;
        fireOnPreWrite(PROPERTY_POSSIBLE_METIERS, oldValue, possibleMetiers);
        this.possibleMetiers = possibleMetiers;
        fireOnPostWrite(PROPERTY_POSSIBLE_METIERS, oldValue, possibleMetiers);
    }

    @Override
    public Metier getPossibleMetiers() {
        Metier result = this.possibleMetiers;

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_FISHING_OPERATION, this.fishingOperation).
            append(PROPERTY_FISHING_OPERATION_DURATION, this.fishingOperationDuration).
            append(PROPERTY_GEARS_NUMBER_PER_OPERATION, this.gearsNumberPerOperation).
            append(PROPERTY_CREW_SIZE, this.crewSize).
            append(PROPERTY_UNIT_COST_OF_FISHING, this.unitCostOfFishing).
            append(PROPERTY_FIXED_CREW_SALARY, this.fixedCrewSalary).
            append(PROPERTY_CREW_SHARE_RATE, this.crewShareRate).
            append(PROPERTY_CREW_FOOD_COST, this.crewFoodCost).
            append(PROPERTY_REPAIR_AND_MAINTENANCE_GEAR_COST, this.repairAndMaintenanceGearCost).
            append(PROPERTY_OTHER_RUNNING_COST, this.otherRunningCost).
            append(PROPERTY_LANDING_COSTS, this.landingCosts).
         toString();
        return result;
    }

} //EffortDescriptionAbstract
