/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: SaveEntity.java 589 2012-09-02 15:11:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/SaveEntity.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.struts2.interceptor.ParameterAware;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.metadata.TableMeta;

import java.util.List;
import java.util.Map;

/**
 * Save the edition of a row of a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class SaveEntity extends EchoBaseActionSupport implements ParameterAware {

    private static final long serialVersionUID = 1L;

    /** Type of entity to save. */
    protected EchoBaseEntityEnum entityType;

    /** id of entity to save. */
    protected String topiaId;

    public EchoBaseEntityEnum getEntityType() {
        return entityType;
    }

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    @Override
    public String execute() throws Exception {

        DbEditorService service = getService(DbEditorService.class);

        TableMeta<EchoBaseEntityEnum> tableMeta = service.getTableMeta(entityType);
        Map<String, String> properties = Maps.newHashMap();
        List<String> columnNames = tableMeta.getColumnNames();
        Map<String, String[]> parameters = getParameters();
        for (String columnName : columnNames) {
            if (parameters.containsKey(columnName)) {

                // there is a such property to edit
                String[] values = parameters.get(columnName);

                if (values.length > 0) {

                    // take only the first value
                    String propertyValue = values[0];

                    // only keep properties with no empty value
                    properties.put(columnName, propertyValue);
                }
            }
        }
        properties.put(TopiaEntity.TOPIA_ID, topiaId);

        service.saveEntity(tableMeta,
                           properties,
                           getEchoBaseSession().getUser());

        return SUCCESS;
    }
}

