/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;

public abstract class AbstractConfigureImport<M extends AbstractImportConfiguration>
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractConfigureImport.class);
    protected final Class<M> modelType;
    protected M model;

    protected AbstractConfigureImport(Class<M> modelType) {
        this.modelType = modelType;
    }

    public final M getModel() {
        if (this.model == null) {
            this.model = this.createModel();
        }
        return (M)this.model;
    }

    protected abstract M createModel();

    public String input() throws Exception {
        this.getEchoBaseSession().removeImportDataConfiguration(this.modelType);
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        AbstractImportConfiguration importModel = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-importData-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        importModel.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        for (InputFile inputFile : importModel.getInputFiles()) {
            if (!inputFile.hasFile()) continue;
            this.copyFile(inputFile, dataDirectory);
        }
        this.setInSession(importModel);
        return "success";
    }

    protected final void setInSession(M model) {
        this.getEchoBaseSession().setImportDataConfiguration(model);
    }

    protected final M getFromSession() {
        return (M)this.getEchoBaseSession().getImportDataConfiguration(this.modelType);
    }

    public final void setModel(M model) {
        this.model = model;
    }

    protected <E extends TopiaEntity> Map<String, String> loadSortAndDecorate(EchoBaseServiceSupport service, Class<E> beanType) {
        List beans = service.getEntities(beanType);
        return this.getDecoratorService().sortAndDecorate(this.getLocale(), (Collection)beans, null);
    }
}

