/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ManageExportQuery.java 51 2011-11-13 16:20:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/ManageExportQuery.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.entities.ExportQueryImpl;
import fr.ifremer.echobase.services.ExportSqlService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * To manage {@link ExportQuery}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class ManageExportQuery extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Selected query */
    protected ExportQuery query;

    public ExportQuery getQuery() {
        if (query == null) {
            query = new ExportQueryImpl();
        }
        return query;
    }

    public String saveQuery() throws Exception {

        //TODO : do validation
        ExportSqlService service = newService(ExportSqlService.class);

        query = service.createOrUpdate(getQuery(),
                                       getEchoBaseSession().getEchoBaseUser()
        );
        return SUCCESS;
    }

    public String cloneQuery() throws Exception {

        //TODO : do validation
        ExportSqlService service = newService(ExportSqlService.class);

        getQuery().setTopiaId(null);
        query = service.createOrUpdate(getQuery(),
                                       getEchoBaseSession().getEchoBaseUser()
        );
        return SUCCESS;
    }

    public String deleteQuery() throws Exception {

        //TODO : do validation
        ExportSqlService service = newService(ExportSqlService.class);
        service.delete(getQuery().getTopiaId());
        query = null;
        return SUCCESS;
    }
}