package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import fr.ifremer.coselmar.persistence.DaoUtils;

public class DocumentTopiaDao extends AbstractDocumentTopiaDao<Document> {

    public List<Document> findAllContainingAllKeywords(List<String> keywords) {

        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<Document> queryBuilder = newQueryBuilder();
        for (String keyword : keywords) {
            queryBuilder.addContains(Document.PROPERTY_KEYWORDS, keyword);
        }

        List<Document> documents = queryBuilder.findAll();
        return documents;
    }

    public List<Document> findAllFilterByUser(CoselmarUser currentUser, List<String> keywords) {

        StringBuilder hqlBuilder = new StringBuilder("FROM " + Document.class.getName() + " D");

        Map<String, Object> args = new HashMap<>();

        // can list all public document
        String privacyPublicCondition = DaoUtils.getQueryForAttributeEquals("D", Document.PROPERTY_PRIVACY, args, DocumentPrivacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( " + privacyPublicCondition);

        // Can list his own private document
        String privacyPrivateCondition = DaoUtils.getQueryForAttributeEquals("D", Document.PROPERTY_PRIVACY, args, DocumentPrivacy.PRIVATE, "");
        String ownerCondition = DaoUtils.andAttributeEquals("D", Document.PROPERTY_OWNER, args, currentUser);

        hqlBuilder.append(" OR ( " + privacyPrivateCondition + " " + ownerCondition + " ) )");

        // Manage keywords
        if (keywords != null) {
            for (String keyword : keywords) {
                String containsKeyword = DaoUtils.andAttributeContains("D", Document.PROPERTY_KEYWORDS, args, keyword);
                hqlBuilder.append(containsKeyword);
            }
        }

        List<Document> documents = forHql(hqlBuilder.toString(), args).findAll();

        return documents;
    }

} //DocumentTopiaDao
