/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services;

import fr.ifremer.coselmar.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.CoselmarTopiaApplicationContext;
import fr.ifremer.coselmar.services.CoselmarService;
import fr.ifremer.coselmar.services.CoselmarServicesContext;
import fr.ifremer.coselmar.services.indexation.LuceneUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultCoselmarServicesContext
implements CoselmarServicesContext {
    private static final Log log = LogFactory.getLog(DefaultCoselmarServicesContext.class);
    protected CoselmarServicesConfig servicesConfig;
    protected CoselmarPersistenceContext persistenceContext;
    protected Locale locale;
    protected LuceneUtils luceneUtils;
    private CoselmarTopiaApplicationContext topiaApplicationContext;

    public void setCoselmarServicesConfig(CoselmarServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setTopiaApplicationContext(CoselmarTopiaApplicationContext topiaApplicationContext) {
        this.topiaApplicationContext = topiaApplicationContext;
    }

    public void setPersistenceContext(CoselmarPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setLuceneUtils(LuceneUtils luceneUtils) {
        this.luceneUtils = luceneUtils;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Date getNow() {
        Date now = new Date();
        return now;
    }

    public CoselmarTopiaApplicationContext getTopiaApplicationContext() {
        return this.topiaApplicationContext;
    }

    public CoselmarPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public CoselmarServicesConfig getCoselmarServicesConfig() {
        return this.servicesConfig;
    }

    public LuceneUtils getLuceneUtils() {
        return this.luceneUtils;
    }

    public <E extends CoselmarService> E newService(Class<E> serviceClass) {
        CoselmarService service;
        try {
            Constructor<E> constructor = serviceClass.getConstructor(new Class[0]);
            service = (CoselmarService)constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CoselmarTechnicalException("all services must provide a default public constructor", (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CoselmarTechnicalException("unable to instantiate coselmar service", (Throwable)e);
        }
        service.setServicesContext((CoselmarServicesContext)this);
        return (E)service;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public String getCleanMail(String email) {
        return email == null ? null : StringUtils.lowerCase((String)email.trim());
    }

    public String generateSalt() {
        SecureRandom secureRandom;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = new SecureRandom();
        }
        byte[] salt = new byte[16];
        secureRandom.nextBytes(salt);
        return salt.toString();
    }

    public String generatePassword() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    public String encodePassword(String salt, String password) {
        String encodedPassword = DefaultCoselmarServicesContext.getSecurePassword((String)salt, (String)password, (String)this.getCoselmarServicesConfig().getEncryptionAlgorithm());
        return encodedPassword;
    }

    protected static String getSecurePassword(String salt, String passwordToHash, String algorithm) {
        String generatedPassword;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(salt.getBytes());
            byte[] passwordBytes = digest.digest(passwordToHash.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < passwordBytes.length; ++i) {
                stringBuilder.append(Integer.toString((passwordBytes[i] & 0xFF) + 256, 16).substring(1));
            }
            generatedPassword = stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            String errorMessage = "Unable to encode password";
            if (log.isErrorEnabled()) {
                log.error((Object)errorMessage, (Throwable)e);
            }
            throw new CoselmarTechnicalException(errorMessage);
        }
        return generatedPassword;
    }
}

