/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.context;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.transfer.TransferListener;

public final class ContextOverrides {
    public static final RemoteRepository CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").setReleasePolicy(new RepositoryPolicy(true, "never", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "never", "warn")).build();
    public static final Path DEFAULT_BASEDIR = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
    public static final Path DEFAULT_USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]).toAbsolutePath();
    public static final Path DEFAULT_MAVEN_USER_HOME = DEFAULT_USER_HOME.resolve(".m2");
    private final Path basedir;
    private final Map<String, String> systemProperties;
    private final Map<String, String> userProperties;
    private final Map<String, Object> configProperties;
    private final List<RemoteRepository> repositories;
    private final boolean appendRepositories;
    private final boolean offline;
    private final SnapshotUpdatePolicy snapshotUpdatePolicy;
    private final ChecksumPolicy checksumPolicy;
    private final boolean withUserSettings;
    private final List<String> activeProfileIds;
    private final List<String> inactiveProfileIds;
    private final RepositoryListener repositoryListener;
    private final TransferListener transferListener;
    private final MavenUserHome mavenUserHome;
    private final Path globalSettingsXmlOverride;
    private final MavenSystemHome mavenSystemHome;
    private final Object effectiveSettings;

    private ContextOverrides(Path basedir, Map<String, String> systemProperties, Map<String, String> userProperties, Map<String, Object> configProperties, List<RemoteRepository> repositories, boolean appendRepositories, boolean offline, SnapshotUpdatePolicy snapshotUpdatePolicy, ChecksumPolicy checksumPolicy, boolean withUserSettings, List<String> activeProfileIds, List<String> inactiveProfileIds, RepositoryListener repositoryListener, TransferListener transferListener, MavenUserHome mavenUserHome, Path globalSettingsXmlOverride, MavenSystemHome mavenSystemHome, Object effectiveSettings) {
        this.basedir = Objects.requireNonNull(basedir);
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
        this.userProperties = Collections.unmodifiableMap(userProperties);
        this.configProperties = Collections.unmodifiableMap(configProperties);
        this.repositories = Collections.unmodifiableList(repositories);
        this.appendRepositories = appendRepositories;
        this.offline = offline;
        this.snapshotUpdatePolicy = snapshotUpdatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.withUserSettings = withUserSettings;
        this.activeProfileIds = Collections.unmodifiableList(activeProfileIds);
        this.inactiveProfileIds = Collections.unmodifiableList(inactiveProfileIds);
        this.repositoryListener = repositoryListener;
        this.transferListener = transferListener;
        this.mavenUserHome = mavenUserHome;
        this.globalSettingsXmlOverride = globalSettingsXmlOverride;
        this.mavenSystemHome = mavenSystemHome;
        this.effectiveSettings = effectiveSettings;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public boolean isAppendRepositories() {
        return this.appendRepositories;
    }

    public boolean isOffline() {
        return this.offline;
    }

    @Deprecated
    public Path getLocalRepository() {
        return this.getMavenUserHome().localRepository();
    }

    public SnapshotUpdatePolicy getSnapshotUpdatePolicy() {
        return this.snapshotUpdatePolicy;
    }

    public ChecksumPolicy getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public boolean isWithUserSettings() {
        return this.withUserSettings;
    }

    public List<String> getActiveProfileIds() {
        return this.activeProfileIds;
    }

    public List<String> getInactiveProfileIds() {
        return this.inactiveProfileIds;
    }

    @Deprecated
    public Path getSettingsXml() {
        return this.getMavenUserHome().settingsXml();
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public MavenUserHome getMavenUserHome() {
        return this.mavenUserHome;
    }

    public Path getGlobalSettingsXmlOverride() {
        return this.globalSettingsXmlOverride;
    }

    public MavenSystemHome getMavenSystemHome() {
        return this.mavenSystemHome;
    }

    public Object getEffectiveSettings() {
        return this.effectiveSettings;
    }

    public static Map<String, String> defaultSystemProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(System.getenv().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>("env." + (String)e.getKey(), (String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        result.putAll(System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
        return result;
    }

    private static Path safeAbsolute(Path path) {
        if (path == null) {
            return null;
        }
        return path.toAbsolutePath();
    }

    public static enum SnapshotUpdatePolicy {
        ALWAYS,
        NEVER;

    }

    public static enum ChecksumPolicy {
        FAIL,
        WARN,
        IGNORE;

    }

    public static final class MavenUserHome {
        private final Path mavenUserHome;
        private final Path settingsXmlOverride;
        private final Path settingsSecurityXmlOverride;
        private final Path localRepositoryOverride;

        public MavenUserHome() {
            this(DEFAULT_MAVEN_USER_HOME);
        }

        public MavenUserHome(Path mavenUserHome) {
            this(mavenUserHome, null, null, null);
        }

        public MavenUserHome(Path mavenUserHome, Path settingsXmlOverride, Path settingsSecurityXmlOverride, Path localRepositoryOverride) {
            this.mavenUserHome = Objects.requireNonNull(mavenUserHome);
            this.settingsXmlOverride = settingsXmlOverride;
            this.settingsSecurityXmlOverride = settingsSecurityXmlOverride;
            this.localRepositoryOverride = localRepositoryOverride;
        }

        public Path basedir() {
            return this.mavenUserHome;
        }

        public Path settingsXml() {
            if (this.settingsXmlOverride != null) {
                return this.settingsXmlOverride;
            }
            return this.basedir().resolve("settings.xml");
        }

        public Path settingsSecurityXml() {
            if (this.settingsSecurityXmlOverride != null) {
                return this.settingsSecurityXmlOverride;
            }
            return this.basedir().resolve("settings-security.xml");
        }

        public Path localRepository() {
            if (this.localRepositoryOverride != null) {
                return this.localRepositoryOverride;
            }
            return this.basedir().resolve("repository");
        }
    }

    public static final class MavenSystemHome {
        private final Path mavenSystemHome;

        public MavenSystemHome(Path mavenSystemHome) {
            this.mavenSystemHome = Objects.requireNonNull(mavenSystemHome);
        }

        public Path basedir() {
            return this.mavenSystemHome;
        }

        public Path bin() {
            return this.basedir().resolve("bin");
        }

        public Path boot() {
            return this.basedir().resolve("boot");
        }

        public Path conf() {
            return this.basedir().resolve("conf");
        }

        public Path lib() {
            return this.basedir().resolve("lib");
        }

        public Path m2Conf() {
            return this.bin().resolve("m2.conf");
        }

        public Path mvn() {
            return this.bin().resolve("mvn");
        }

        public Path mvnCmd() {
            return this.bin().resolve("mvn.cmd");
        }

        public Path mvnDebug() {
            return this.bin().resolve("mvnDebug");
        }

        public Path mvnDebugCmd() {
            return this.bin().resolve("mvnDebug.cmd");
        }

        public Path settingsXml() {
            return this.conf().resolve("settings.xml");
        }

        public Path toolchainsXml() {
            return this.conf().resolve("toolchains.xml");
        }

        public Path confLogging() {
            return this.conf().resolve("logging");
        }

        public Path simpleloggerProperties() {
            return this.confLogging().resolve("simplelogger.properties");
        }

        public Path libExt() {
            return this.lib().resolve("ext");
        }
    }

    public static final class Builder {
        private Path basedir = DEFAULT_BASEDIR;
        private Map<String, String> systemProperties = ContextOverrides.defaultSystemProperties();
        private Map<String, String> userProperties = new HashMap<String, String>();
        private Map<String, Object> configProperties = new HashMap<String, Object>();
        private List<RemoteRepository> repositories = Collections.singletonList(CENTRAL);
        private boolean appendRepositories = false;
        private boolean offline = false;
        private SnapshotUpdatePolicy snapshotUpdatePolicy = null;
        private ChecksumPolicy checksumPolicy = null;
        private boolean withUserSettings = false;
        private List<String> activeProfileIds = Collections.emptyList();
        private List<String> inactiveProfileIds = Collections.emptyList();
        private RepositoryListener repositoryListener = null;
        private TransferListener transferListener = null;
        private Path mavenUserHome = DEFAULT_MAVEN_USER_HOME;
        private Path userSettingsXmlOverride = null;
        private Path userSettingsSecurityXmlOverride = null;
        private Path localRepositoryOverride = null;
        private Path globalSettingsXmlOverride = null;
        private Path mavenSystemHome = null;
        private Object effectiveSettings = null;

        public static Builder create() {
            return new Builder();
        }

        public Builder withBasedir(Path basedir) {
            Objects.requireNonNull(basedir, "basedir cannot be null");
            if (!Files.isDirectory(basedir, new LinkOption[0])) {
                throw new IllegalArgumentException("basedir must be existing directory: " + basedir);
            }
            this.basedir = basedir;
            return this;
        }

        public Builder systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties != null ? new HashMap<String, String>(systemProperties) : new HashMap<String, String>();
            return this;
        }

        public Builder userProperties(Map<String, String> userProperties) {
            this.userProperties = userProperties != null ? new HashMap<String, String>(userProperties) : new HashMap<String, String>();
            return this;
        }

        public Builder configProperties(Map<String, Object> configProperties) {
            this.configProperties = configProperties != null ? new HashMap<String, Object>(configProperties) : new HashMap<String, Object>();
            return this;
        }

        public Builder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories != null ? new ArrayList<RemoteRepository>(repositories) : Collections.emptyList();
            return this;
        }

        public Builder appendRepositories(boolean appendRepositories) {
            this.appendRepositories = appendRepositories;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Deprecated
        public Builder localRepository(Path localRepository) {
            return this.withLocalRepositoryOverride(localRepository);
        }

        public Builder snapshotUpdatePolicy(SnapshotUpdatePolicy snapshotUpdatePolicy) {
            this.snapshotUpdatePolicy = snapshotUpdatePolicy;
            return this;
        }

        public Builder checksumPolicy(ChecksumPolicy checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        public Builder withUserSettings(boolean withUserSettings) {
            this.withUserSettings = withUserSettings;
            return this;
        }

        public Builder withActiveProfileIds(List<String> activeProfileIds) {
            this.activeProfileIds = activeProfileIds != null ? activeProfileIds : Collections.emptyList();
            return this;
        }

        public Builder withInactiveProfileIds(List<String> inactiveProfileIds) {
            this.inactiveProfileIds = inactiveProfileIds != null ? inactiveProfileIds : Collections.emptyList();
            return this;
        }

        @Deprecated
        public Builder settingsXml(Path settingsXml) {
            return this.withSettingsXmlOverride(settingsXml);
        }

        public Builder repositoryListener(RepositoryListener repositoryListener) {
            this.repositoryListener = repositoryListener;
            return this;
        }

        public Builder transferListener(TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public Builder withMavenUserHome(Path mavenUserHome) {
            Objects.requireNonNull(mavenUserHome);
            this.mavenUserHome = mavenUserHome;
            return this;
        }

        public Builder withSettingsXmlOverride(Path settingsXmlOverride) {
            return this.withUserSettingsXmlOverride(settingsXmlOverride);
        }

        public Builder withUserSettingsXmlOverride(Path userSettingsXmlOverride) {
            this.userSettingsXmlOverride = userSettingsXmlOverride;
            return this;
        }

        public Builder withSettingsSecurityXmlOverride(Path settingsSecurityXmlOverride) {
            return this.withUserSettingsSecurityXmlOverride(settingsSecurityXmlOverride);
        }

        public Builder withUserSettingsSecurityXmlOverride(Path userSettingsSecurityXmlOverride) {
            this.userSettingsSecurityXmlOverride = userSettingsSecurityXmlOverride;
            return this;
        }

        public Builder withLocalRepositoryOverride(Path localRepositoryOverride) {
            this.localRepositoryOverride = localRepositoryOverride;
            return this;
        }

        public Builder withGlobalSettingsXmlOverride(Path globalSettingsXmlOverride) {
            this.globalSettingsXmlOverride = globalSettingsXmlOverride;
            return this;
        }

        public Builder withMavenSystemHome(Path mavenSystemHome) {
            this.mavenSystemHome = mavenSystemHome;
            return this;
        }

        public Builder withEffectiveSettings(Object effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
            return this;
        }

        public ContextOverrides build() {
            Path effectiveMavenSystemHome;
            String localRepoPath;
            HashMap<String, String> effectiveConfigProperties = new HashMap<String, String>(this.systemProperties);
            effectiveConfigProperties.putAll(this.userProperties);
            effectiveConfigProperties.putAll(this.configProperties);
            Path effectiveLocalRepository = ContextOverrides.safeAbsolute(this.localRepositoryOverride);
            if (effectiveLocalRepository == null && (localRepoPath = (String)effectiveConfigProperties.get("maven.repo.local")) != null) {
                effectiveLocalRepository = Paths.get(localRepoPath, new String[0]).toAbsolutePath();
            }
            if ((effectiveMavenSystemHome = ContextOverrides.safeAbsolute(this.mavenSystemHome)) == null) {
                String mavenHome = (String)effectiveConfigProperties.get("maven.home");
                if (mavenHome == null) {
                    mavenHome = (String)effectiveConfigProperties.get("env.MAVEN_HOME");
                }
                if (mavenHome != null) {
                    effectiveMavenSystemHome = Paths.get(mavenHome, new String[0]).toAbsolutePath();
                }
            }
            return new ContextOverrides(this.basedir, this.systemProperties, this.userProperties, effectiveConfigProperties, this.repositories, this.appendRepositories, this.offline, this.snapshotUpdatePolicy, this.checksumPolicy, this.withUserSettings, this.activeProfileIds, this.inactiveProfileIds, this.repositoryListener, this.transferListener, new MavenUserHome(this.mavenUserHome.toAbsolutePath(), ContextOverrides.safeAbsolute(this.userSettingsXmlOverride), ContextOverrides.safeAbsolute(this.userSettingsSecurityXmlOverride), effectiveLocalRepository), this.globalSettingsXmlOverride, effectiveMavenSystemHome == null ? null : new MavenSystemHome(effectiveMavenSystemHome), this.effectiveSettings);
        }
    }
}

