/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SchemeRecordBuilder {
    public static final String outFilename = "records.scm";
    public static final int INDENT_AMT = 3;
    public static final int MAX_PER_LINE = 4;
    private Vector classList;
    private PrintWriter out;

    public SchemeRecordBuilder(Vector classes) {
        this.classList = classes;
    }

    public void generateSchemeRecords() throws FileExistsException {
        try {
            File file = new File(outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            this.out = new PrintWriter(new FileOutputStream(file), false);
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                Vector types = cur.getTypeList();
                int numFields = cur.getNameList().size();
                int numPerLine = 1;
                if (cur.getNameList().size() <= 1 && types.elementAt(0).equals("NodeChoice")) continue;
                Hashtable<String, Integer> typeCounts = new Hashtable<String, Integer>();
                this.out.print("(define-record " + name + " (");
                for (int i = 0; i < numFields; ++i) {
                    if (types.elementAt(i).equals("NodeChoice")) {
                        Errors.softErr("In production " + name + ": choices may " + "only occur at the top level.");
                    } else if (types.elementAt(i).equals("NodeSequence")) {
                        Errors.softErr("In production " + name + ": only single " + "nonterminals may appear within Lists, ListOptionals," + " Optionals, and Choices.");
                    } else {
                        String curType = (String)types.elementAt(i);
                        Integer cntForType = (Integer)typeCounts.get(curType);
                        if (types.elementAt(i).equals("NodeList") || types.elementAt(i).equals("NodeListOptional")) {
                            this.out.print("List");
                        } else if (types.elementAt(i).equals("NodeOptional")) {
                            this.out.print("Optional");
                        } else if (types.elementAt(i).equals("NodeToken")) {
                            this.out.print("Token");
                        } else {
                            this.out.print(curType);
                        }
                        if (cntForType == null) {
                            for (int j = i + 1; j < numFields; ++j) {
                                if (!types.elementAt(j).equals(curType)) continue;
                                this.out.print("1");
                                break;
                            }
                            typeCounts.put(curType, new Integer(1));
                        } else {
                            int newVal = cntForType + 1;
                            this.out.print(newVal);
                            typeCounts.put(curType, new Integer(newVal));
                        }
                    }
                    ++numPerLine;
                    if (i >= numFields - 1) continue;
                    if (numPerLine >= 4) {
                        this.out.println();
                        this.out.print("   ");
                        numPerLine = 0;
                        continue;
                    }
                    this.out.print(" ");
                }
                this.out.println("))");
            }
            this.out.flush();
            this.out.close();
        }
        catch (IOException e) {
            Errors.hardErr("Could not generate records.scm");
        }
    }
}

