/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.AutoClasses;
import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FileGenerator {
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File nodeDir;
    private File visitorDir;

    public FileGenerator(Vector classes) {
        this.classList = classes;
        this.nodeDir = new File(Globals.nodeDir);
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.nodeDir.exists()) {
            this.nodeDir.mkdir();
        } else if (!this.nodeDir.isDirectory()) {
            Errors.softErr("\"" + Globals.nodeDir + "\" exists but is not a " + "directory.");
        }
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        } else if (!this.visitorDir.isDirectory()) {
            Errors.softErr("\"" + Globals.visitorDir + "\" exists but is not a " + "directory.");
        }
    }

    public void printClassList(PrintWriter out) {
        Spacing spc = new Spacing(3);
        Enumeration e = this.classList.elements();
        while (e.hasMoreElements()) {
            ClassInfo cur = (ClassInfo)e.nextElement();
            String name = cur.getName();
            out.println(spc.spc + "class " + name + ":");
            spc.updateSpc(1);
            Enumeration types = cur.getTypeList().elements();
            Enumeration names = cur.getNameList().elements();
            while (types.hasMoreElements()) {
                out.println(spc.spc + (String)types.nextElement() + " " + (String)names.nextElement());
            }
            out.println();
            spc.updateSpc(-1);
        }
        out.flush();
    }

    public void generateClassFiles() throws FileExistsException {
        try {
            boolean exists = false;
            Spacing spc = new Spacing(3);
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                File file = new File(this.nodeDir, cur.getName() + ".java");
                if (Globals.noOverwrite && file.exists()) {
                    exists = true;
                    break;
                }
                PrintWriter out = new PrintWriter(new FileOutputStream(file), false);
                out.println(spc.spc + Globals.fileHeader(spc));
                out.println();
                out.println(spc.spc + "package " + Globals.nodePackage + ";");
                out.println();
                out.println(spc.spc + "/**");
                out.println(spc.spc + " * Grammar production:");
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * <PRE>");
                }
                out.println(spc.spc + cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * </PRE>");
                }
                out.println(spc.spc + " */");
                out.println(cur.getClassString(spc));
                out.flush();
                out.close();
            }
            if (Globals.noOverwrite && exists) {
                throw new FileExistsException("one of the generated node classes");
            }
        }
        catch (IOException e) {
            Errors.hardErr(e);
        }
    }

    public void generateAutoClassFiles() throws FileExistsException {
        try {
            boolean b = true;
            b = b && this.printStringToFile("Node.java", AutoClasses.getNodeClassStr());
            b = b && this.printStringToFile("NodeListInterface.java", AutoClasses.getNodeListInterfaceClassStr());
            b = b && this.printStringToFile("NodeChoice.java", AutoClasses.getNodeChoiceClassStr());
            b = b && this.printStringToFile("NodeList.java", AutoClasses.getNodeListClassStr());
            b = b && this.printStringToFile("NodeListOptional.java", AutoClasses.getNodeListOptionalClassStr());
            b = b && this.printStringToFile("NodeOptional.java", AutoClasses.getNodeOptionalClassStr());
            b = b && this.printStringToFile("NodeSequence.java", AutoClasses.getNodeSequenceClassStr());
            boolean bl = b = b && this.printStringToFile("NodeToken.java", AutoClasses.getNodeTokenClassStr());
            if (Globals.noOverwrite && !b) {
                throw new FileExistsException("one of the automatic node classes");
            }
        }
        catch (IOException e) {
            Errors.hardErr(e);
        }
    }

    private boolean printStringToFile(String fname, String s) throws IOException {
        File file = new File(Globals.nodeDir, fname);
        if (Globals.noOverwrite && file.exists()) {
            return false;
        }
        PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
        out.println(Globals.fileHeader());
        out.println();
        out.println(s);
        out.close();
        return true;
    }

    public void generateVisitorFile() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, "GJVisitor.java");
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException("GJVisitor.java");
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spc = new Spacing(3);
            out.println(Globals.fileHeader(spc));
            out.println();
            out.println(spc.spc + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                out.println(spc.spc + "import " + Globals.nodePackage + ".*;");
            }
            out.println(spc.spc + "import java.util.*;\n");
            out.println(spc.spc + "/**");
            out.println(spc.spc + " * All GJ visitors must implement this interface.");
            out.println(spc.spc + " */\n");
            out.println(spc.spc + "public interface " + "GJVisitor" + "<R,A> {\n");
            this.printAutoVisitorMethods(out);
            spc.updateSpc(1);
            out.println(spc.spc + "//");
            out.println(spc.spc + "// User-generated visitor methods below");
            out.println(spc.spc + "//");
            out.println();
            Enumeration e = this.classList.elements();
            while (e.hasMoreElements()) {
                ClassInfo cur = (ClassInfo)e.nextElement();
                String name = cur.getName();
                out.println(spc.spc + "/**");
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * <PRE>");
                }
                out.println(cur.getEbnfProduction(spc));
                if (Globals.javaDocComments) {
                    out.println(spc.spc + " * </PRE>");
                }
                out.println(spc.spc + " */");
                out.print(spc.spc + "public R visit");
                out.println("(" + name + " n, A argu);\n");
            }
            spc.updateSpc(-1);
            out.println(spc.spc + "}");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Errors.hardErr(e);
        }
    }

    private void printAutoVisitorMethods(PrintWriter out) {
        out.println("   //");
        out.println("   // GJ Auto class visitors");
        out.println("   //\n");
        out.print(AutoClasses.getNodeListVisitorStr());
        out.print(AutoClasses.getNodeListOptionalVisitorStr());
        out.print(AutoClasses.getNodeOptionalVisitorStr());
        out.print(AutoClasses.getNodeSequenceVisitorStr());
        out.print(AutoClasses.getNodeTokenVisitorStr());
        out.println();
    }
}

