/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.xmpp;

import edu.internet2.middleware.grouperClient.api.GcGetMembers;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetMembersResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubject;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.Expression;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.ExpressionFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.JexlContext;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl.JexlHelper;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.util.JsonUtils;
import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvent;
import edu.internet2.middleware.grouperClientExt.xmpp.EsbEvents;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppHandler;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppJob;
import edu.internet2.middleware.grouperClientExt.xmpp.GrouperClientXmppSubject;
import edu.internet2.middleware.grouperClientExt.xmpp.MembershipFullRefreshJob;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class GrouperClientXmppMain {
    private static Log log = GrouperClientUtils.retrieveLog(GrouperClientXmppMain.class);
    private static XMPPConnection xmppConnection = null;
    private static Set<String> allowFromJabberIds = new HashSet<String>();
    private static Map<String, List<GrouperClientXmppSubject>> groupMemberships = new HashMap<String, List<GrouperClientXmppSubject>>();
    private static SchedulerFactory schedulerFactory = null;

    public static boolean matchesFilter(EsbEvent esbEvent, String filterString) {
        try {
            Expression e = ExpressionFactory.createExpression(filterString);
            JexlContext jc = JexlHelper.createContext();
            jc.getVars().put("event", esbEvent);
            jc.getVars().put("grouperClientUtils", new GrouperClientUtils());
            return (Boolean)e.evaluate(jc);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem seeing if matches filter for sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", '" + filterString + "'", e);
        }
    }

    private static synchronized XMPPConnection xmppConnection() {
        if (xmppConnection == null || !xmppConnection.isAuthenticated() || !xmppConnection.isConnected()) {
            String user = null;
            String pass = null;
            String resource = null;
            String server = null;
            int port = -1;
            try {
                if (xmppConnection != null) {
                    try {
                        xmppConnection.disconnect();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                server = GrouperClientXmppMain.xmppServer();
                port = GrouperClientXmppMain.xmppPort();
                ConnectionConfiguration config = new ConnectionConfiguration(server, port);
                boolean debuggerEnabled = GrouperClientUtils.propertiesValueBoolean("grouperClient.xmpp.debuggerEnabled", false, false);
                config.setDebuggerEnabled(debuggerEnabled);
                config.setReconnectionAllowed(true);
                config.setSASLAuthenticationEnabled(true);
                SASLAuthentication.supportSASLMechanism((String)"PLAIN");
                config.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
                xmppConnection = new XMPPConnection(config);
                xmppConnection.connect();
                user = GrouperClientXmppMain.xmppUser();
                pass = GrouperClientXmppMain.xmppPass();
                resource = GrouperClientXmppMain.xmppResource();
                xmppConnection.login(user, pass, resource);
            }
            catch (XMPPException xe) {
                throw new RuntimeException("Problem connecting: server: " + server + ", port: " + port + ",  user: " + user + ", pass not included, " + ", resource: " + resource, xe);
            }
        }
        return xmppConnection;
    }

    private static String xmppPass() {
        String passFromFile;
        boolean disableExternalFileLookup = GrouperClientUtils.propertiesValueBoolean("encrypt.disableExternalFileLookup", false, true);
        String pass = GrouperClientUtils.propertiesValue("grouperClient.xmpp.pass", true);
        if (!GrouperClientUtils.equals(pass, passFromFile = GrouperClientUtils.readFromFileIfFile(pass, disableExternalFileLookup))) {
            String encryptKey = GrouperClientUtils.propertiesValue("encrypt.key", true);
            encryptKey = GrouperClientUtils.readFromFileIfFile(encryptKey, disableExternalFileLookup);
            passFromFile = new Crypto(encryptKey).decrypt(passFromFile);
        }
        return passFromFile;
    }

    private static int xmppPort() {
        return GrouperClientUtils.propertiesValueInt("grouperClient.xmpp.server.port", 1522, false);
    }

    private static String xmppResource() {
        return GrouperClientUtils.propertiesValue("grouperClient.xmpp.resource", false);
    }

    private static String xmppServer() {
        return GrouperClientUtils.propertiesValue("grouperClient.xmpp.server.host", true);
    }

    private static String xmppUser() {
        return GrouperClientUtils.propertiesValue("grouperClient.xmpp.user", true);
    }

    private static void xmppConnect() {
        XMPPConnection theXmppConnection = GrouperClientXmppMain.xmppConnection();
        theXmppConnection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = null;
                try {
                    message = (Message)packet;
                    if (log.isDebugEnabled()) {
                        log.debug(message == null ? null : message.toXML());
                    }
                    String body = message.getBody();
                    EsbEvents esbEvents = (EsbEvents)JsonUtils.jsonConvertFrom(body, EsbEvents.class);
                    for (EsbEvent esbEvent : GrouperClientUtils.nonNull(esbEvents.getEsbEvent(), EsbEvent.class)) {
                        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
                            String elfilter = grouperClientXmppJob.getElfilter();
                            Boolean matches = null;
                            if (!GrouperClientUtils.isBlank(elfilter)) {
                                if (!GrouperClientXmppMain.matchesFilter(esbEvent, elfilter)) {
                                    matches = false;
                                    if (log.isDebugEnabled()) {
                                        log.debug("skipping event to not match filter, sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", '" + elfilter + "', " + grouperClientXmppJob.getJobName());
                                    }
                                } else {
                                    matches = true;
                                }
                            }
                            if (GrouperClientUtils.nonNull(grouperClientXmppJob.getGroupNames()).size() > 0) {
                                if (grouperClientXmppJob.getGroupNames().contains(esbEvent.getGroupName())) {
                                    if (matches == null) {
                                        matches = true;
                                    }
                                } else {
                                    if (log.isDebugEnabled()) {
                                        log.debug("skipping event to not match group name list, sequence: " + (esbEvent == null ? null : esbEvent.getSequenceNumber()) + ", " + grouperClientXmppJob.getJobName());
                                    }
                                    matches = false;
                                }
                            }
                            if (matches != null && !matches.booleanValue()) continue;
                            if (GrouperClientXmppJob.XmppJobEventAction.reload_group == grouperClientXmppJob.getEventAction()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("performing a full reload on group: " + esbEvent.getGroupName() + " for job: " + grouperClientXmppJob.getJobName() + ", subject: " + esbEvent.getSubjectId());
                                }
                                GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, esbEvent.getGroupName());
                                continue;
                            }
                            if (GrouperClientXmppJob.XmppJobEventAction.incremental == grouperClientXmppJob.getEventAction()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("performing an incremental reload on group: " + esbEvent.getGroupName() + " for job: " + grouperClientXmppJob.getJobName() + ", subject: " + esbEvent.getSubjectId());
                                }
                                GrouperClientXmppSubject grouperClientXmppSubject = new GrouperClientXmppSubject(esbEvent);
                                GrouperClientXmppMain.incrementalRefreshGroup(grouperClientXmppJob, esbEvent.getGroupName(), grouperClientXmppSubject, esbEvent.getEventType());
                                continue;
                            }
                            throw new RuntimeException("Not expecting event action: " + (Object)((Object)grouperClientXmppJob.getEventAction()));
                        }
                    }
                }
                catch (Throwable re) {
                    String messageXml = message == null ? null : message.toXML();
                    log.error("Problem with message: " + messageXml, re);
                    throw new RuntimeException(re);
                }
            }
        }, new PacketFilter(){

            public boolean accept(Packet packet) {
                Message message;
                Message.Type type;
                if (packet instanceof Message && (type = (message = (Message)packet).getType()) == Message.Type.chat && !GrouperClientUtils.isBlank(message.getBody())) {
                    if (allowFromJabberIds.contains(message.getFrom())) {
                        return true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Not expecting message from: " + message.getFrom());
                    }
                }
                return false;
            }
        });
    }

    public static void main(String[] args) {
        GrouperClientXmppMain.fullRefreshAll();
        String allowFroms = GrouperClientUtils.propertiesValue("grouperClient.xmpp.trustedMessagesFromJabberIds", true);
        allowFromJabberIds.addAll(GrouperClientUtils.splitTrimToList(allowFroms, ","));
        GrouperClientXmppMain.scheduleFullRefreshJobs();
        GrouperClientXmppMain.xmppLoop();
    }

    public static void fullRefreshGroup(GrouperClientXmppJob grouperClientXmppJob, String groupName) {
        GcGetMembers gcGetMembers = new GcGetMembers();
        List<String> subjectAttributeNames = grouperClientXmppJob.getSubjectAttributeNames();
        if (GrouperClientUtils.length(subjectAttributeNames) > 0) {
            for (String subjectAttributeName : subjectAttributeNames) {
                gcGetMembers.addSubjectAttributeName(subjectAttributeName);
            }
        }
        WsGetMembersResults wsGetMembersResults = gcGetMembers.addGroupName(groupName).execute();
        WsGetMembersResult wsGetMembersResult = wsGetMembersResults.getResults()[0];
        ArrayList<GrouperClientXmppSubject> xmppSubjects = new ArrayList<GrouperClientXmppSubject>();
        for (WsSubject wsSubject : GrouperClientUtils.nonNull(wsGetMembersResult.getWsSubjects(), WsSubject.class)) {
            GrouperClientXmppSubject xmppSubject = new GrouperClientXmppSubject(wsSubject, wsGetMembersResults.getSubjectAttributeNames());
            xmppSubjects.add(xmppSubject);
        }
        if (log.isDebugEnabled()) {
            log.debug("Refreshing all for " + groupName + " found " + GrouperClientUtils.length(xmppSubjects) + " subjects");
        }
        Class handlerClass = GrouperClientUtils.forName(grouperClientXmppJob.getHandlerClass());
        GrouperClientXmppHandler grouperClientXmppHandler = (GrouperClientXmppHandler)GrouperClientUtils.newInstance(handlerClass);
        groupMemberships.put(groupName, xmppSubjects);
        grouperClientXmppHandler.handleAll(grouperClientXmppJob, groupName, GrouperClientUtils.extensionFromName(groupName), xmppSubjects);
    }

    private static void fullRefreshAll() {
        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
            for (String groupName : GrouperClientUtils.nonNull(grouperClientXmppJob.getGroupNames())) {
                GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
            }
        }
    }

    private static void pocEl() {
        String outputTemplate = GrouperClientUtils.propertiesValue("grouperClient.xmpp.job.myJobName.fileHandler.iteratorEl", true);
        outputTemplate = GrouperClientUtils.substituteCommonVars(outputTemplate);
        LinkedHashMap<String, Object> substituteMap = new LinkedHashMap<String, Object>();
        GrouperClientXmppSubject xmppSubject = new GrouperClientXmppSubject();
        xmppSubject.getAttribute().put("loginid", "mchyzer");
        substituteMap.put("subject", xmppSubject);
        String output = GrouperClientUtils.substituteExpressionLanguage(outputTemplate, substituteMap);
        System.out.println(output);
    }

    private static void xmppLoop() {
        while (true) {
            block6: {
                try {
                    if (xmppConnection != null && xmppConnection.isConnected() && xmppConnection.isAuthenticated()) break block6;
                    if (xmppConnection != null) {
                        log.error("xmpp connection is not connected");
                        try {
                            xmppConnection.disconnect();
                        }
                        catch (Exception e) {
                            log.error("error", e);
                        }
                        xmppConnection = null;
                    }
                    GrouperClientXmppMain.xmppConnect();
                }
                catch (Exception e) {
                    log.error("Problem with xmpp", e);
                }
            }
            GrouperClientUtils.sleep(60000L);
        }
    }

    private static void scheduleFullRefreshJobs() {
        for (GrouperClientXmppJob grouperClientXmppJob : GrouperClientXmppJob.retrieveXmppJobs()) {
            Scheduler scheduler = GrouperClientXmppMain.scheduler();
            String jobName = grouperClientXmppJob.getJobName();
            String quartzJobName = "fullRefresh_" + jobName;
            String jobGroup = "DEFAULT";
            JobDetail jobDetail = null;
            if (jobDetail == null) {
                jobDetail = new JobDetail(quartzJobName, jobGroup, MembershipFullRefreshJob.class);
            }
            jobDetail.setDurability(true);
            boolean uniqueTriggerNames = GrouperClientUtils.propertiesValueBoolean("grouperClient.xmpp.uniqueQuartzTriggerNames", false, false);
            String triggerName = "triggerFullRefresh_" + jobName;
            if (uniqueTriggerNames) {
                triggerName = triggerName + GrouperClientUtils.uniqueId();
            }
            CronTrigger cronTrigger = null;
            if (!uniqueTriggerNames) {
                try {
                    cronTrigger = (CronTrigger)scheduler.getTrigger(triggerName, jobGroup);
                }
                catch (SchedulerException se) {
                    throw new RuntimeException("Problem with trigger: " + jobName, se);
                }
            }
            if (cronTrigger == null) {
                cronTrigger = new CronTrigger(triggerName, jobGroup);
            }
            String quartzCronString = grouperClientXmppJob.getFullRefreshQuartzCronString();
            try {
                cronTrigger.setCronExpression(quartzCronString);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Problems parsing: '" + quartzCronString + "'", pe);
            }
            try {
                try {
                    if (!uniqueTriggerNames) {
                        scheduler.unscheduleJob(triggerName, quartzJobName);
                    }
                }
                catch (Exception e) {
                    log.warn("Non fatal error unscheduling job", e);
                }
                try {
                    scheduler.deleteJob(quartzJobName, jobGroup);
                }
                catch (Exception e) {
                    log.warn("Non fatal error deleting job", e);
                }
                scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            }
            catch (SchedulerException se) {
                throw new RuntimeException("Problem with job: " + jobName, se);
            }
        }
    }

    private static Scheduler scheduler() {
        try {
            return GrouperClientXmppMain.schedulerFactory().getScheduler();
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
    }

    public static SchedulerFactory schedulerFactory() {
        if (schedulerFactory == null) {
            schedulerFactory = new StdSchedulerFactory();
            try {
                schedulerFactory.getScheduler().start();
            }
            catch (SchedulerException se) {
                throw new RuntimeException(se);
            }
        }
        return schedulerFactory;
    }

    private static void incrementalRefreshGroup(GrouperClientXmppJob grouperClientXmppJob, String groupName, GrouperClientXmppSubject grouperClientXmppSubject, String eventType) {
        List<GrouperClientXmppSubject> oldList = groupMemberships.get(groupName);
        if (oldList == null) {
            GrouperClientXmppMain.fullRefreshGroup(grouperClientXmppJob, groupName);
            oldList = groupMemberships.get(groupName);
        }
        if (oldList == null) {
            throw new NullPointerException("Why is old list null????");
        }
        ArrayList<GrouperClientXmppSubject> newList = new ArrayList<GrouperClientXmppSubject>(oldList);
        if (GrouperClientUtils.equals(eventType, "MEMBERSHIP_ADD")) {
            if (!newList.contains(grouperClientXmppSubject)) {
                newList.add(grouperClientXmppSubject);
            } else if (log.isDebugEnabled()) {
                log.debug("Group " + groupName + " already contains subject: " + grouperClientXmppSubject.getSubjectId());
            }
        } else if (GrouperClientUtils.equals(eventType, "MEMBERSHIP_DELETE")) {
            if (newList.contains(grouperClientXmppSubject)) {
                int i = 0;
                while (newList.remove(grouperClientXmppSubject)) {
                    if (i++ <= 100) continue;
                    throw new RuntimeException("Time to live exceeded for group " + groupName + ", subject " + grouperClientXmppSubject.getSubjectId());
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Group " + groupName + " already doesnt contain subject: " + grouperClientXmppSubject.getSubjectId());
            }
        } else {
            throw new RuntimeException("Not expecting action: '" + eventType + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug("Refreshing incremental for " + groupName + " was " + GrouperClientUtils.length(oldList) + " and is now " + GrouperClientUtils.length(newList) + " subjects");
        }
        Class handlerClass = GrouperClientUtils.forName(grouperClientXmppJob.getHandlerClass());
        GrouperClientXmppHandler grouperClientXmppHandler = (GrouperClientXmppHandler)GrouperClientUtils.newInstance(handlerClass);
        groupMemberships.put(groupName, newList);
        grouperClientXmppHandler.handleIncremental(grouperClientXmppJob, groupName, GrouperClientUtils.extensionFromName(groupName), newList, oldList, grouperClientXmppSubject, eventType);
    }
}

