/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.extended;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.ConversionException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

public class JavaClassConverter
extends AbstractSingleValueConverter {
    private ClassLoader classLoader;

    public JavaClassConverter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JavaClassConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean canConvert(Class clazz) {
        return Class.class.equals((Object)clazz);
    }

    public String toString(Object obj) {
        return ((Class)obj).getName();
    }

    public Object fromString(String str) {
        try {
            return this.loadClass(str);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException("Cannot load java class " + str, e);
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        Class resultingClass = this.primitiveClassForName(className);
        if (resultingClass != null) {
            return resultingClass;
        }
        int dimension = 0;
        while (className.charAt(dimension) == '[') {
            ++dimension;
        }
        if (dimension > 0) {
            ClassLoader classLoaderToUse;
            if (className.charAt(dimension) == 'L') {
                String componentTypeName = className.substring(dimension + 1, className.length() - 1);
                classLoaderToUse = this.classLoader.loadClass(componentTypeName).getClassLoader();
            } else {
                classLoaderToUse = null;
            }
            return Class.forName(className, false, classLoaderToUse);
        }
        return this.classLoader.loadClass(className);
    }

    private Class primitiveClassForName(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }
}

