/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestStemDeleteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsStemLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcStemDelete {
    private List<WsStemLookup> stemLookups = new ArrayList<WsStemLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;
    private String clientVersion;

    @Deprecated
    public GcStemDelete addGroupLookup(WsStemLookup wsStemLookup) {
        return this.addStemLookup(wsStemLookup);
    }

    public GcStemDelete addStemLookup(WsStemLookup wsStemLookup) {
        this.stemLookups.add(wsStemLookup);
        return this;
    }

    public GcStemDelete addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcStemDelete addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcStemDelete assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.stemLookups) == 0) {
            throw new RuntimeException("Need at least one group to delete: " + this);
        }
    }

    public GcStemDelete assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcStemDelete assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsStemDeleteResults execute() {
        this.validate();
        WsStemDeleteResults wsStemDeleteResults = null;
        try {
            WsRestStemDeleteRequest stemDelete = new WsRestStemDeleteRequest();
            stemDelete.setActAsSubjectLookup(this.actAsSubject);
            stemDelete.setTxType(this.txType == null ? null : this.txType.name());
            stemDelete.setWsStemLookups(GrouperClientUtils.toArray(this.stemLookups, WsStemLookup.class));
            if (this.params.size() > 0) {
                stemDelete.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsStemDeleteResults = (WsStemDeleteResults)grouperClientWs.executeService("stems", stemDelete, "stemDelete", this.clientVersion);
            String resultMessage = wsStemDeleteResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsStemDeleteResults, wsStemDeleteResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsStemDeleteResults;
    }
}

