/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignPermissionsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeAssignLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsMembershipAnyLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignPermissionsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignPermissions {
    private Timestamp assignmentDisabledTime;
    private Timestamp assignmentEnabledTime;
    private String assignmentNotes;
    private String permissionAssignOperation;
    private String delegatable;
    private String clientVersion;
    private String permissionType;
    private Set<String> actions = new LinkedHashSet<String>();
    private Set<String> roleNames = new LinkedHashSet<String>();
    private Set<String> roleUuids = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<WsMembershipAnyLookup> subjectRoleLookups = new LinkedHashSet<WsMembershipAnyLookup>();
    private Set<WsAttributeAssignLookup> attributeAssignLookups = new LinkedHashSet<WsAttributeAssignLookup>();
    private Set<String> permissionDefNameNames = new LinkedHashSet<String>();
    private Set<String> permissionDefNameUuids = new LinkedHashSet<String>();
    private Set<String> actionsToReplace = new LinkedHashSet<String>();
    private Set<String> attributeDefNamesToReplace = new LinkedHashSet<String>();
    private Set<String> attributeDefUuidsToReplace = new LinkedHashSet<String>();

    public GcAssignPermissions assignPermissionType(String thePermissionType) {
        this.permissionType = thePermissionType;
        return this;
    }

    public GcAssignPermissions addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public GcAssignPermissions assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignPermissions addRoleName(String theRoleName) {
        this.roleNames.add(theRoleName);
        return this;
    }

    public GcAssignPermissions addRoleUuid(String theRoleUuid) {
        this.roleUuids.add(theRoleUuid);
        return this;
    }

    public GcAssignPermissions addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignPermissions addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignPermissions assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.permissionType)) {
            throw new RuntimeException("attributeAssignType is required: " + this);
        }
    }

    public GcAssignPermissions addSubjectRoleLookup(WsMembershipAnyLookup subjectRoleLookup) {
        this.subjectRoleLookups.add(subjectRoleLookup);
        return this;
    }

    public GcAssignPermissions addAttributeAssignId(String attributeAssignId) {
        WsAttributeAssignLookup wsAttributeAssignLookup = new WsAttributeAssignLookup();
        wsAttributeAssignLookup.setUuid(attributeAssignId);
        this.attributeAssignLookups.add(wsAttributeAssignLookup);
        return this;
    }

    public GcAssignPermissions addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAssignPermissions assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAssignPermissions assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsAssignPermissionsResults execute() {
        this.validate();
        WsAssignPermissionsResults wsAssignPermissionsResults = null;
        try {
            WsRestAssignPermissionsRequest assignPermissions = new WsRestAssignPermissionsRequest();
            assignPermissions.setActAsSubjectLookup(this.actAsSubject);
            ArrayList<WsAttributeDefNameLookup> permissionDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
            for (String attributeDefNameName : this.permissionDefNameNames) {
                permissionDefNameLookups.add(new WsAttributeDefNameLookup(attributeDefNameName, null));
            }
            for (String attributeDefNameUuid : this.permissionDefNameUuids) {
                permissionDefNameLookups.add(new WsAttributeDefNameLookup(null, attributeDefNameUuid));
            }
            if (GrouperClientUtils.length(permissionDefNameLookups) > 0) {
                assignPermissions.setPermissionDefNameLookups(GrouperClientUtils.toArray(permissionDefNameLookups, WsAttributeDefNameLookup.class));
            }
            ArrayList<WsGroupLookup> roleLookups = new ArrayList<WsGroupLookup>();
            for (String ownerGroupName : this.roleNames) {
                roleLookups.add(new WsGroupLookup(ownerGroupName, null));
            }
            for (String ownerGroupUuid : this.roleUuids) {
                roleLookups.add(new WsGroupLookup(null, ownerGroupUuid));
            }
            if (GrouperClientUtils.length(roleLookups) > 0) {
                assignPermissions.setRoleLookups(GrouperClientUtils.toArray(roleLookups, WsGroupLookup.class));
            }
            if (GrouperClientUtils.length(this.subjectRoleLookups) > 0) {
                assignPermissions.setSubjectRoleLookups(GrouperClientUtils.toArray(this.subjectRoleLookups, WsMembershipAnyLookup.class));
            }
            if (GrouperClientUtils.length(this.actionsToReplace) > 0) {
                assignPermissions.setActionsToReplace(GrouperClientUtils.toArray(this.actionsToReplace, String.class));
            }
            ArrayList<WsAttributeDefLookup> attributeDefLookupsToReplace = new ArrayList<WsAttributeDefLookup>();
            for (String attributeDefNameToReplace : this.attributeDefNamesToReplace) {
                attributeDefLookupsToReplace.add(new WsAttributeDefLookup(attributeDefNameToReplace, null));
            }
            for (String attributeDefUuidToReplace : this.attributeDefUuidsToReplace) {
                attributeDefLookupsToReplace.add(new WsAttributeDefLookup(null, attributeDefUuidToReplace));
            }
            if (GrouperClientUtils.length(attributeDefLookupsToReplace) > 0) {
                assignPermissions.setAttributeDefsToReplace(GrouperClientUtils.toArray(attributeDefLookupsToReplace, WsAttributeDefLookup.class));
            }
            if (this.includeGroupDetail != null) {
                assignPermissions.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                assignPermissions.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.assignmentDisabledTime != null) {
                String disabledTime = GrouperClientUtils.dateToString(this.assignmentDisabledTime);
                assignPermissions.setAssignmentDisabledTime(disabledTime);
            }
            if (this.assignmentEnabledTime != null) {
                String enabledTime = GrouperClientUtils.dateToString(this.assignmentEnabledTime);
                assignPermissions.setAssignmentEnabledTime(enabledTime);
            }
            assignPermissions.setAssignmentNotes(this.assignmentNotes);
            assignPermissions.setPermissionAssignOperation(this.permissionAssignOperation);
            assignPermissions.setDelegatable(this.delegatable);
            if (GrouperClientUtils.length(this.attributeAssignLookups) > 0) {
                assignPermissions.setWsAttributeAssignLookups(GrouperClientUtils.toArray(this.attributeAssignLookups, WsAttributeAssignLookup.class));
            }
            assignPermissions.setPermissionType(this.permissionType);
            if (this.params.size() > 0) {
                assignPermissions.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (this.subjectAttributeNames.size() > 0) {
                assignPermissions.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (GrouperClientUtils.length(this.actions) > 0) {
                assignPermissions.setActions(GrouperClientUtils.toArray(this.actions, String.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAssignPermissionsResults = (WsAssignPermissionsResults)grouperClientWs.executeService("permissionAssignments", assignPermissions, "getPermissionAssignments", this.clientVersion);
            String resultMessage = wsAssignPermissionsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAssignPermissionsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignPermissionsResults;
    }

    public GcAssignPermissions addPermissionDefNameName(String thePermissionDefNameName) {
        this.permissionDefNameNames.add(thePermissionDefNameName);
        return this;
    }

    public GcAssignPermissions addPermissionDefNameUuid(String thePermissionDefNameUuid) {
        this.permissionDefNameUuids.add(thePermissionDefNameUuid);
        return this;
    }

    public GcAssignPermissions assignDisabledTime(Timestamp theDisabledTime) {
        this.assignmentDisabledTime = theDisabledTime;
        return this;
    }

    public GcAssignPermissions assignEnabledTime(Timestamp theEnabledTime) {
        this.assignmentEnabledTime = theEnabledTime;
        return this;
    }

    public GcAssignPermissions assignAssignmentNotes(String theAssignmentNotes) {
        this.assignmentNotes = theAssignmentNotes;
        return this;
    }

    public GcAssignPermissions assignPermissionAssignOperation(String thePermissionAssignOperation) {
        this.permissionAssignOperation = thePermissionAssignOperation;
        return this;
    }

    public GcAssignPermissions assignDelegatable(String theDelegatable) {
        this.delegatable = theDelegatable;
        return this;
    }

    public GcAssignPermissions addActionToReplace(String action) {
        this.actionsToReplace.add(action);
        return this;
    }

    public GcAssignPermissions addAttributeDefNameToReplace(String theAttributeDefName) {
        this.attributeDefNamesToReplace.add(theAttributeDefName);
        return this;
    }

    public GcAssignPermissions addAttributeDefUuidToReplace(String theAttributeDefUuid) {
        this.attributeDefUuidsToReplace.add(theAttributeDefUuid);
        return this;
    }
}

