/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.Lock;
import it.sauronsoftware.junique.Message;
import it.sauronsoftware.junique.MessageHandler;
import it.sauronsoftware.junique.Server;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Hashtable;

public class JUnique {
    private static final File LOCK_FILES_DIR = new File(System.getProperty("user.home"), ".junique");
    private static final File GLOBAL_LOCK_FILE = new File(LOCK_FILES_DIR, "global.lock");
    private static FileChannel globalFileChannel = null;
    private static FileLock globalFileLock = null;
    private static Hashtable locks = new Hashtable();

    public static void acquireLock(String string) throws AlreadyLockedException {
        JUnique.acquireLock(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void acquireLock(String string, MessageHandler messageHandler) throws AlreadyLockedException {
        String string2 = JUnique.normalizeID(string);
        JUnique.j_lock();
        try {
            FileLock fileLock;
            FileChannel fileChannel;
            Object object;
            File file = JUnique.getLockFileForNID(string2);
            File file2 = JUnique.getPortFileForNID(string2);
            LOCK_FILES_DIR.mkdirs();
            try {
                object = new RandomAccessFile(file, "rw");
                fileChannel = ((RandomAccessFile)object).getChannel();
                fileLock = fileChannel.tryLock();
                if (fileLock == null) {
                    throw new AlreadyLockedException(string);
                }
            }
            catch (Throwable throwable) {
                throw new AlreadyLockedException(string);
            }
            Server server = new Server(string, messageHandler);
            object = new Lock(string, file, file2, fileChannel, fileLock, server);
            locks.put(string2, object);
            server.start();
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(file2);
            fileWriter.write(String.valueOf(server.getListenedPort()));
            ((Writer)fileWriter).flush();
            if (fileWriter == null) return;
            try {
                ((Writer)fileWriter).close();
                return;
            }
            catch (Throwable throwable) {}
            return;
            catch (Throwable throwable) {
                if (fileWriter == null) return;
                try {
                    ((Writer)fileWriter).close();
                    return;
                }
                catch (Throwable throwable2) {}
                return;
                catch (Throwable throwable3) {
                    if (fileWriter == null) throw throwable3;
                    try {
                        ((Writer)fileWriter).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw throwable3;
                }
            }
        }
        finally {
            JUnique.j_unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseLock(String string) {
        String string2 = JUnique.normalizeID(string);
        JUnique.j_lock();
        try {
            Lock lock = (Lock)locks.remove(string2);
            if (lock != null) {
                JUnique.releaseLock(lock);
            }
        }
        finally {
            JUnique.j_unlock();
        }
    }

    private static void releaseLock(Lock lock) {
        lock.getServer().stop();
        try {
            lock.getLockFileLock().release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            lock.getLockFileChannel().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lock.getPortFile().delete();
        lock.getLockFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendMessage(String string, String string2) {
        Object object;
        Closeable closeable;
        Object object2;
        String string3;
        int n;
        block41: {
            n = -1;
            JUnique.j_lock();
            try {
                string3 = JUnique.normalizeID(string);
                object2 = JUnique.getPortFileForNID(string3);
                closeable = null;
                try {
                    closeable = new BufferedReader(new FileReader((File)object2));
                    object = ((BufferedReader)closeable).readLine();
                    if (object != null) {
                        n = Integer.parseInt((String)object);
                    }
                    if (closeable == null) break block41;
                }
                catch (Throwable throwable) {
                    if (closeable != null) {
                        try {
                            ((BufferedReader)closeable).close();
                        }
                        catch (Throwable throwable2) {}
                    }
                    break block41;
                    catch (Throwable throwable3) {
                        if (closeable == null) throw throwable3;
                        try {
                            ((BufferedReader)closeable).close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                        throw throwable3;
                    }
                }
                try {
                    ((BufferedReader)closeable).close();
                }
                catch (Throwable throwable) {}
            }
            finally {
                JUnique.j_unlock();
            }
        }
        string3 = null;
        if (n <= 0) return string3;
        object2 = null;
        closeable = null;
        object = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            object2 = new Socket(inetAddress, n);
            closeable = ((Socket)object2).getInputStream();
            object = ((Socket)object2).getOutputStream();
            Message.write(string2, (OutputStream)object);
            string3 = Message.read((InputStream)closeable);
            return string3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return string3;
        }
        finally {
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (Throwable throwable) {}
            }
            if (closeable != null) {
                try {
                    ((InputStream)closeable).close();
                }
                catch (Throwable throwable) {}
            }
            if (object2 != null) {
                try {
                    ((Socket)object2).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static String normalizeID(String string) {
        int n = string.hashCode();
        boolean bl = n >= 0;
        long l = bl ? (long)n : -((long)n);
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        while (stringBuffer.length() < 8) {
            stringBuffer.insert(0, '0');
        }
        if (bl) {
            stringBuffer.insert(0, '0');
        } else {
            stringBuffer.insert(0, '1');
        }
        return stringBuffer.toString();
    }

    private static File getLockFileForNID(String string) {
        String string2 = JUnique.normalizeID(string) + ".lock";
        return new File(LOCK_FILES_DIR, string2);
    }

    private static File getPortFileForNID(String string) {
        String string2 = JUnique.normalizeID(string) + ".port";
        return new File(LOCK_FILES_DIR, string2);
    }

    private static void j_lock() {
        while (true) {
            LOCK_FILES_DIR.mkdirs();
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(GLOBAL_LOCK_FILE, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                FileLock fileLock = fileChannel.lock();
                globalFileChannel = fileChannel;
                globalFileLock = fileLock;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static void j_unlock() {
        FileChannel fileChannel = globalFileChannel;
        FileLock fileLock = globalFileLock;
        globalFileChannel = null;
        globalFileLock = null;
        try {
            fileLock.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fileChannel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        if (!LOCK_FILES_DIR.exists()) {
            LOCK_FILES_DIR.mkdirs();
        }
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(new ShutdownHook()));
    }

    private static class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JUnique.j_lock();
            try {
                String string;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object = locks.keys();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    arrayList.add(string);
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    Lock lock = (Lock)locks.remove(string);
                    JUnique.releaseLock(lock);
                }
            }
            finally {
                JUnique.j_unlock();
            }
        }
    }
}

