/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.IntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONLogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public final class JSONIntermediateResponseAccessLogMessage
extends JSONRequestAccessLogMessage
implements IntermediateResponseAccessLogMessage {
    private static final long serialVersionUID = -8154114903633681042L;
    @NotNull
    private final AccessLogOperationType operationType;
    @NotNull
    private final Set<String> responseControlOIDs;
    @Nullable
    private final String intermediateResponseName;
    @Nullable
    private final String oid = this.getString(JSONFormattedAccessLogFields.INTERMEDIATE_RESPONSE_OID);
    @Nullable
    private final String valueString;

    public JSONIntermediateResponseAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.intermediateResponseName = this.getString(JSONFormattedAccessLogFields.INTERMEDIATE_RESPONSE_NAME);
        this.valueString = this.getString(JSONFormattedAccessLogFields.INTERMEDIATE_RESPONSE_VALUE);
        this.responseControlOIDs = this.getStringSet(JSONFormattedAccessLogFields.RESPONSE_CONTROL_OIDS);
        String operationTypeName = this.getString(JSONFormattedAccessLogFields.OPERATION_TYPE);
        if (operationTypeName == null) {
            String jsonObjectString = jsonObject.toSingleLineString();
            throw new LogException(jsonObjectString, JSONLogMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_IDENTIFY_OPERATION_TYPE.get(jsonObjectString));
        }
        this.operationType = AccessLogOperationType.forName(operationTypeName);
        if (this.operationType == null) {
            String jsonObjectString = jsonObject.toSingleLineString();
            throw new LogException(jsonObjectString, JSONLogMessages.ERR_INTERMEDIATE_RESPONSE_CANNOT_IDENTIFY_OPERATION_TYPE.get(jsonObjectString));
        }
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.INTERMEDIATE_RESPONSE;
    }

    @Override
    @NotNull
    public AccessLogOperationType getOperationType() {
        return this.operationType;
    }

    @Override
    @Nullable
    public String getOID() {
        return this.oid;
    }

    @Override
    @Nullable
    public String getResponseName() {
        return this.intermediateResponseName;
    }

    @Override
    @Nullable
    public String getValueString() {
        return this.valueString;
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.responseControlOIDs;
    }
}

