/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.CaseIgnoreStringMatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SplitLDIFAttributeHashTranslator
extends SplitLDIFTranslator {
    private final boolean useAllValues;
    private final ConcurrentHashMap<String, Set<String>> rdnCache;
    private final Map<Integer, Set<String>> setNames;
    private final Set<String> outsideSplitBaseSetNames;
    private final Set<String> splitBaseEntrySetNames;
    private final String attributeName;

    SplitLDIFAttributeHashTranslator(DN splitBaseDN, int numSets, String attributeName, boolean useAllValues, boolean assumeFlatDIT, boolean addEntriesOutsideSplitToAllSets, boolean addEntriesOutsideSplitToDedicatedSet) {
        super(splitBaseDN);
        this.attributeName = attributeName;
        this.useAllValues = useAllValues;
        this.rdnCache = assumeFlatDIT ? null : new ConcurrentHashMap(StaticUtils.computeMapCapacity(100));
        this.outsideSplitBaseSetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets + 1));
        this.splitBaseEntrySetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets));
        if (addEntriesOutsideSplitToDedicatedSet) {
            this.outsideSplitBaseSetNames.add(".outside-split");
        }
        this.setNames = new LinkedHashMap<Integer, Set<String>>(StaticUtils.computeMapCapacity(numSets));
        for (int i = 0; i < numSets; ++i) {
            String setName = ".set" + (i + 1);
            this.setNames.put(i, Collections.singleton(setName));
            this.splitBaseEntrySetNames.add(setName);
            if (!addEntriesOutsideSplitToAllSets) continue;
            this.outsideSplitBaseSetNames.add(setName);
        }
    }

    @Override
    public SplitLDIFEntry translate(Entry original, long firstLineNumber) throws LDIFException {
        MessageDigest md5Digest;
        DN dn;
        try {
            dn = original.getParsedDN();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_ATTR_HASH_TRANSLATOR_CANNOT_PARSE_DN.get(le.getMessage()), this.getErrorSetNames());
        }
        if (!dn.isDescendantOf(this.getSplitBaseDN(), true)) {
            return this.createEntry(original, this.outsideSplitBaseSetNames);
        }
        if (dn.equals(this.getSplitBaseDN())) {
            return this.createEntry(original, this.splitBaseEntrySetNames);
        }
        RDN[] rdns = dn.getRDNs();
        int targetRDNIndex = rdns.length - this.getSplitBaseRDNs().length - 1;
        String normalizedRDNString = rdns[targetRDNIndex].toNormalizedString();
        if (targetRDNIndex > 0) {
            if (this.rdnCache == null) {
                return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_ATTR_HASH_TRANSLATOR_NON_FLAT_DIT.get(this.getSplitBaseDN().toString()), this.getErrorSetNames());
            }
            return this.createEntry(original, this.rdnCache.get(normalizedRDNString));
        }
        try {
            md5Digest = this.getMD5();
            md5Digest.reset();
        }
        catch (Exception e) {
            Debug.debugException(e);
            return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_TRANSLATOR_CANNOT_GET_MD5.get(StaticUtils.getExceptionMessage(e)), this.getErrorSetNames());
        }
        byte[] md5Bytes = null;
        Attribute a = original.getAttribute(this.attributeName);
        if (a != null) {
            MatchingRule mr = a.getMatchingRule();
            if (mr == null) {
                mr = CaseIgnoreStringMatchingRule.getInstance();
            }
            if (this.useAllValues && a.size() > 1) {
                try {
                    TreeSet<String> sortedValues = new TreeSet<String>();
                    for (ASN1OctetString value : a.getRawValues()) {
                        sortedValues.add(mr.normalize(value).stringValue());
                    }
                    for (String value : sortedValues) {
                        md5Digest.update(StaticUtils.getBytes(value));
                    }
                    md5Bytes = md5Digest.digest();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            } else if (a.size() != 0) {
                try {
                    md5Bytes = md5Digest.digest(mr.normalize(a.getRawValues()[0]).getValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        if (md5Bytes == null) {
            md5Bytes = md5Digest.digest(StaticUtils.getBytes(normalizedRDNString));
        }
        int checksum = (md5Bytes[0] & 0x7F) << 24 | (md5Bytes[1] & 0xFF) << 16 | (md5Bytes[2] & 0xFF) << 8 | md5Bytes[3] & 0xFF;
        int setNumber = checksum % this.setNames.size();
        Set<String> sets = this.setNames.get(setNumber);
        if (this.rdnCache != null) {
            this.rdnCache.put(normalizedRDNString, sets);
        }
        return this.createEntry(original, sets);
    }
}

