/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.ldap.sdk.unboundidds.monitors.ThreadStackTrace;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StackTraceMonitorEntry
extends MonitorEntry {
    static final String STACK_TRACE_MONITOR_OC = "ds-stack-trace-monitor-entry";
    private static final String ATTR_JVM_STACK_TRACE = "jvmThread";
    private static final long serialVersionUID = -9008690818438183908L;
    private final List<ThreadStackTrace> stackTraces;

    public StackTraceMonitorEntry(Entry entry) {
        super(entry);
        List<String> traceLines = this.getStrings(ATTR_JVM_STACK_TRACE);
        if (traceLines.isEmpty()) {
            this.stackTraces = Collections.emptyList();
        } else {
            ArrayList<ThreadStackTrace> traces = new ArrayList<ThreadStackTrace>(100);
            try {
                int currentThreadID = -1;
                String currentName = null;
                ArrayList<StackTraceElement> currentElements = new ArrayList<StackTraceElement>(20);
                for (String line : traceLines) {
                    String fileName;
                    int spacePos;
                    int equalPos;
                    int id = Integer.parseInt(line.substring((equalPos = line.indexOf(61)) + 1, spacePos = line.indexOf(32, equalPos)));
                    if (id != currentThreadID) {
                        if (currentThreadID >= 0) {
                            traces.add(new ThreadStackTrace(currentThreadID, currentName, currentElements));
                        }
                        currentThreadID = id;
                        currentElements = new ArrayList(20);
                        int dashesPos1 = line.indexOf("---------- ", spacePos);
                        int dashesPos2 = line.indexOf(" ----------", dashesPos1);
                        currentName = line.substring(dashesPos1 + 11, dashesPos2);
                        continue;
                    }
                    int bePos = line.indexOf("]=");
                    String traceLine = line.substring(bePos + 2);
                    int lineNumber = -1;
                    int closeParenPos = traceLine.lastIndexOf(41);
                    int openParenPos = traceLine.lastIndexOf(40, closeParenPos);
                    int colonPos = traceLine.lastIndexOf(58, closeParenPos);
                    if (colonPos < 0) {
                        fileName = traceLine.substring(openParenPos + 1, closeParenPos);
                    } else {
                        fileName = traceLine.substring(openParenPos + 1, colonPos);
                        String lineNumberStr = traceLine.substring(colonPos + 1, closeParenPos);
                        if (lineNumberStr.equalsIgnoreCase("native")) {
                            lineNumber = -2;
                        } else {
                            try {
                                lineNumber = Integer.parseInt(lineNumberStr);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    int periodPos = traceLine.lastIndexOf(46, openParenPos);
                    String className = traceLine.substring(0, periodPos);
                    String methodName = traceLine.substring(periodPos + 1, openParenPos);
                    currentElements.add(new StackTraceElement(className, methodName, fileName, lineNumber));
                }
                if (currentThreadID >= 0) {
                    traces.add(new ThreadStackTrace(currentThreadID, currentName, currentElements));
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            this.stackTraces = Collections.unmodifiableList(traces);
        }
    }

    public List<ThreadStackTrace> getStackTraces() {
        return this.stackTraces;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_STACK_TRACE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_STACK_TRACE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(1));
        Attribute traceAttr = this.getEntry().getAttribute(ATTR_JVM_STACK_TRACE);
        if (traceAttr != null) {
            StackTraceMonitorEntry.addMonitorAttribute(attrs, ATTR_JVM_STACK_TRACE, MonitorMessages.INFO_STACK_TRACE_DISPNAME_TRACE.get(), MonitorMessages.INFO_STACK_TRACE_DESC_TRACE.get(), Collections.unmodifiableList(Arrays.asList(traceAttr.getValues())));
        }
        return Collections.unmodifiableMap(attrs);
    }
}

