/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AbandonForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AbandonResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.AddAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.BindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.CompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.DisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.EntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.EntryRebalancingResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.IntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.ModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchReferenceAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.SecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.UnbindRequestAccessLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccessLogReader
implements Closeable {
    private final BufferedReader reader;

    public AccessLogReader(String path) throws IOException {
        this.reader = new BufferedReader(new FileReader(path));
    }

    public AccessLogReader(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
    }

    public AccessLogReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public AccessLogMessage read() throws IOException, LogException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return null;
        } while (line.isEmpty() || line.charAt(0) == '#');
        return AccessLogReader.parse(line);
    }

    public static AccessLogMessage parse(String s) throws LogException {
        LogMessage m = new LogMessage(s);
        if (m.hasUnnamedValue(AccessLogMessageType.CONNECT.getLogIdentifier())) {
            return new ConnectAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.DISCONNECT.getLogIdentifier())) {
            return new DisconnectAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.CLIENT_CERTIFICATE.getLogIdentifier())) {
            return new ClientCertificateAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.SECURITY_NEGOTIATION.getLogIdentifier())) {
            return new SecurityNegotiationAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.ENTRY_REBALANCING_REQUEST.getLogIdentifier())) {
            return new EntryRebalancingRequestAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.ENTRY_REBALANCING_RESULT.getLogIdentifier())) {
            return new EntryRebalancingResultAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.REQUEST.getLogIdentifier())) {
            if (m.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchRequestAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.UNBIND.getLogIdentifier())) {
                return new UnbindRequestAccessLogMessage(m);
            }
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_REQUEST_OPERATION_TYPE.get());
        }
        if (m.hasUnnamedValue(AccessLogMessageType.RESULT.getLogIdentifier())) {
            if (m.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNResultAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchResultAccessLogMessage(m);
            }
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_RESULT_OPERATION_TYPE.get());
        }
        if (m.hasUnnamedValue(AccessLogMessageType.FORWARD.getLogIdentifier())) {
            if (m.hasUnnamedValue(AccessLogOperationType.ABANDON.getLogIdentifier())) {
                return new AbandonForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNForwardAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchForwardAccessLogMessage(m);
            }
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_FORWARD_OPERATION_TYPE.get());
        }
        if (m.hasUnnamedValue(AccessLogMessageType.FORWARD_FAILED.getLogIdentifier())) {
            if (m.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.BIND.getLogIdentifier())) {
                return new BindForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.COMPARE.getLogIdentifier())) {
                return new CompareForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.EXTENDED.getLogIdentifier())) {
                return new ExtendedForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNForwardFailedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.SEARCH.getLogIdentifier())) {
                return new SearchForwardFailedAccessLogMessage(m);
            }
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_FORWARD_FAILED_OPERATION_TYPE.get());
        }
        if (m.hasUnnamedValue(AccessLogMessageType.ASSURANCE_COMPLETE.getLogIdentifier())) {
            if (m.hasUnnamedValue(AccessLogOperationType.ADD.getLogIdentifier())) {
                return new AddAssuranceCompletedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.DELETE.getLogIdentifier())) {
                return new DeleteAssuranceCompletedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODIFY.getLogIdentifier())) {
                return new ModifyAssuranceCompletedAccessLogMessage(m);
            }
            if (m.hasUnnamedValue(AccessLogOperationType.MODDN.getLogIdentifier())) {
                return new ModifyDNAssuranceCompletedAccessLogMessage(m);
            }
            throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_ASSURANCE_COMPLETE_OPERATION_TYPE.get());
        }
        if (m.hasUnnamedValue(AccessLogMessageType.ENTRY.getLogIdentifier())) {
            return new SearchEntryAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.REFERENCE.getLogIdentifier())) {
            return new SearchReferenceAccessLogMessage(m);
        }
        if (m.hasUnnamedValue(AccessLogMessageType.INTERMEDIATE_RESPONSE.getLogIdentifier())) {
            return new IntermediateResponseAccessLogMessage(m);
        }
        throw new LogException(s, LogMessages.ERR_LOG_MESSAGE_INVALID_ACCESS_MESSAGE_TYPE.get());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

