/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.encoding.ContentType;

public final class ContentTypeImpl
implements com.sun.xml.ws.api.pipe.ContentType {
    @NotNull
    private final String contentType;
    @NotNull
    private final String soapAction;
    private String accept;
    @Nullable
    private final String charset;
    private String boundary;
    private String boundaryParameter;
    private String rootId;

    public ContentTypeImpl(String contentType) {
        this(contentType, null, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction) {
        this(contentType, soapAction, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction, @Nullable String accept) {
        this(contentType, soapAction, accept, null);
    }

    public ContentTypeImpl(String contentType, @Nullable String soapAction, @Nullable String accept, String charsetParam) {
        this.contentType = contentType;
        this.accept = accept;
        this.soapAction = this.getQuotedSOAPAction(soapAction);
        if (charsetParam == null) {
            String tmpCharset = null;
            try {
                tmpCharset = new ContentType(contentType).getParameter("charset");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.charset = tmpCharset;
        } else {
            this.charset = charsetParam;
        }
    }

    @Nullable
    public String getCharSet() {
        return this.charset;
    }

    private String getQuotedSOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return "\"\"";
        }
        if (soapAction.charAt(0) != '\"' && soapAction.charAt(soapAction.length() - 1) != '\"') {
            return "\"" + soapAction + "\"";
        }
        return soapAction;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getSOAPActionHeader() {
        return this.soapAction;
    }

    @Override
    public String getAcceptHeader() {
        return this.accept;
    }

    public void setAcceptHeader(String accept) {
        this.accept = accept;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    public String getBoundaryParameter() {
        return this.boundaryParameter;
    }

    public void setBoundaryParameter(String boundaryParameter) {
        this.boundaryParameter = boundaryParameter;
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public static class Builder {
        public String contentType;
        public String soapAction;
        public String accept;
        public String charset;

        public ContentTypeImpl build() {
            return new ContentTypeImpl(this.contentType, this.soapAction, this.accept, this.charset);
        }
    }
}

