/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.tools.profiler.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceProfiler
implements Serializable,
Cloneable,
SessionProfiler {
    protected List<Profile> profiles = new Vector<Profile>();
    protected transient AbstractSession session;
    protected boolean shouldLogProfile;
    protected int nestLevel;
    protected long nestTime;
    protected long profileTime;
    protected Map<Integer, Map<String, Long>> operationTimingsByThread;
    protected Map<Integer, Map<String, Long>> operationStartTimesByThread;

    public PerformanceProfiler() {
        this(true);
    }

    public PerformanceProfiler(Session session) {
        this(session, true);
    }

    public PerformanceProfiler(Session session, boolean shouldLogProfile) {
        this.session = (AbstractSession)session;
        this.shouldLogProfile = shouldLogProfile;
        this.nestLevel = 0;
        this.operationTimingsByThread = new Hashtable<Integer, Map<String, Long>>();
        this.operationStartTimesByThread = new Hashtable<Integer, Map<String, Long>>();
    }

    public PerformanceProfiler(boolean shouldLogProfile) {
        this.shouldLogProfile = shouldLogProfile;
        this.nestLevel = 0;
        this.profileTime = 0L;
        this.nestTime = 0L;
        this.operationTimingsByThread = new Hashtable<Integer, Map<String, Long>>();
        this.operationStartTimesByThread = new Hashtable<Integer, Map<String, Long>>();
    }

    protected void addProfile(Profile profile) {
        this.getProfiles().add(profile);
    }

    public Profile buildProfileSummary() {
        Profile summary = new Profile();
        summary.setDomainClass(Void.class);
        summary.setQueryClass(Void.class);
        for (Profile profile : this.getProfiles()) {
            if (summary.getShortestTime() == -1L || profile.getTotalTime() < summary.getShortestTime()) {
                summary.setShortestTime(profile.getTotalTime());
            }
            if (profile.getTotalTime() > summary.getLongestTime()) {
                summary.setLongestTime(profile.getTotalTime());
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summary;
    }

    public Hashtable buildProfileSummaryByClass() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        for (Profile profile : this.getProfiles()) {
            Profile summary;
            Class<Void> domainClass = profile.getDomainClass();
            if (domainClass == null) {
                domainClass = Void.class;
            }
            if ((summary = (Profile)summaries.get(domainClass)) == null) {
                summary = new Profile();
                summary.setDomainClass(domainClass);
                summaries.put(domainClass, summary);
            }
            if (summary.getShortestTime() == -1L || profile.getTotalTime() < summary.getShortestTime()) {
                summary.setShortestTime(profile.getTotalTime());
            }
            if (profile.getTotalTime() > summary.getLongestTime()) {
                summary.setLongestTime(profile.getTotalTime());
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summaries;
    }

    public Hashtable buildProfileSummaryByQuery() {
        Hashtable<Class<Void>, Profile> summaries = new Hashtable<Class<Void>, Profile>();
        for (Profile profile : this.getProfiles()) {
            Profile summary;
            Class<Void> queryType = profile.getQueryClass();
            if (queryType == null) {
                queryType = Void.class;
            }
            if ((summary = (Profile)summaries.get(queryType)) == null) {
                summary = new Profile();
                summary.setQueryClass(queryType);
                summaries.put(queryType, summary);
            }
            summary.setTotalTime(summary.getTotalTime() + profile.getTotalTime());
            summary.setLocalTime(summary.getLocalTime() + profile.getLocalTime());
            summary.setProfileTime(summary.getProfileTime() + profile.getProfileTime());
            summary.setNumberOfInstancesEffected(summary.getNumberOfInstancesEffected() + profile.getNumberOfInstancesEffected());
            Enumeration operationNames = profile.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String name = (String)operationNames.nextElement();
                Long oldTime = (Long)summary.getOperationTimings().get(name);
                long profileTime = (Long)profile.getOperationTimings().get(name);
                long newTime = oldTime == null ? profileTime : oldTime + profileTime;
                summary.getOperationTimings().put(name, newTime);
            }
        }
        return summaries;
    }

    public PerformanceProfiler clone() {
        try {
            return (PerformanceProfiler)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void dontLogProfile() {
        this.setShouldLogProfile(false);
    }

    @Override
    public void endOperationProfile(String operationName) {
        Long totalTime;
        long endTime = System.nanoTime();
        Long startTime = this.getOperationStartTimes().get(operationName);
        if (startTime == null) {
            return;
        }
        long time = endTime - startTime;
        if (this.getNestLevel() == 0) {
            if (time == 0L) {
                return;
            }
            Profile profile = new Profile();
            profile.setTotalTime(time);
            profile.setLocalTime(time);
            profile.addTiming(operationName, time);
            this.addProfile(profile);
            if (this.shouldLogProfile()) {
                Writer writer = this.getSession().getLog();
                try {
                    profile.write(writer, this);
                    writer.write(Helper.cr());
                    writer.flush();
                }
                catch (IOException iOException) {}
            }
        }
        if ((totalTime = this.getOperationTimings().get(operationName)) == null) {
            this.getOperationTimings().put(operationName, time);
        } else {
            this.getOperationTimings().put(operationName, totalTime + time);
        }
    }

    @Override
    public void endOperationProfile(String operationName, DatabaseQuery query, int weight) {
        this.endOperationProfile(operationName);
    }

    protected int getNestLevel() {
        return this.nestLevel;
    }

    protected long getNestTime() {
        return this.nestTime;
    }

    protected Map<String, Long> getOperationStartTimes() {
        Integer threadId = Thread.currentThread().hashCode();
        if (this.getOperationStartTimesByThread().get(threadId) == null) {
            this.getOperationStartTimesByThread().put(threadId, new Hashtable(10));
        }
        return this.getOperationStartTimesByThread().get(threadId);
    }

    protected Map<Integer, Map<String, Long>> getOperationStartTimesByThread() {
        return this.operationStartTimesByThread;
    }

    protected Map<String, Long> getOperationTimings() {
        Integer threadId = Thread.currentThread().hashCode();
        if (this.getOperationTimingsByThread().get(threadId) == null) {
            this.getOperationTimingsByThread().put(threadId, new Hashtable(10));
        }
        return this.getOperationTimingsByThread().get(threadId);
    }

    protected Map<Integer, Map<String, Long>> getOperationTimingsByThread() {
        return this.operationTimingsByThread;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    protected long getProfileTime() {
        return this.profileTime;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void logProfile() {
        this.setShouldLogProfile(true);
    }

    public void logProfileSummary() {
        Writer writer = this.getSession().getLog();
        try {
            writer.write(this.buildProfileSummary().toString());
            writer.write(Helper.cr());
        }
        catch (IOException iOException) {}
    }

    public void logProfileSummaryByClass() {
        Hashtable summaries = this.buildProfileSummaryByClass();
        Enumeration classes = summaries.keys();
        while (classes.hasMoreElements()) {
            Class domainClass = (Class)classes.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(summaries.get(domainClass).toString());
                writer.write(Helper.cr());
            }
            catch (IOException iOException) {}
        }
    }

    public void logProfileSummaryByQuery() {
        Hashtable summaries = this.buildProfileSummaryByQuery();
        Enumeration classes = summaries.keys();
        while (classes.hasMoreElements()) {
            Class queryType = (Class)classes.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(summaries.get(queryType).toString());
                writer.write(Helper.cr());
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Object profileExecutionOfQuery(DatabaseQuery query, Record row, AbstractSession session) {
        Object object;
        long profileStartTime = System.nanoTime();
        long nestedProfileStartTime = this.getProfileTime();
        Profile profile = new Profile();
        profile.setQueryClass(query.getClass());
        profile.setDomainClass(query.getReferenceClass());
        Writer writer = this.getSession().getLog();
        Object result = null;
        if (this.shouldLogProfile()) {
            this.writeNestingTabs(writer);
            writer.write(String.valueOf(ToStringLocalization.buildMessage("begin_profile_of", null)) + "{" + query.toString() + Helper.cr());
            writer.flush();
        }
        this.setNestLevel(this.getNestLevel() + 1);
        long startNestTime = this.getNestTime();
        Map timingsBeforeExecution = (Map)((Hashtable)this.getOperationTimings()).clone();
        Map startTimingsBeforeExecution = (Map)((Hashtable)this.getOperationStartTimes()).clone();
        long startTime = System.nanoTime();
        try {
            object = result = session.internalExecuteQuery(query, (AbstractRecord)row);
        }
        catch (Throwable throwable) {
            try {
                long endTime = System.nanoTime();
                this.setNestLevel(this.getNestLevel() - 1);
                for (String name : this.getOperationTimings().keySet()) {
                    Long operationStartTime = (Long)timingsBeforeExecution.get(name);
                    long operationEndTime = this.getOperationTimings().get(name);
                    long operationTime = operationStartTime != null ? operationEndTime - operationStartTime : operationEndTime;
                    profile.addTiming(name, operationTime);
                }
                profile.setTotalTime(endTime - startTime - (this.getProfileTime() - nestedProfileStartTime));
                profile.setLocalTime(profile.getTotalTime() - (this.getNestTime() - startNestTime));
                if (result instanceof Collection) {
                    profile.setNumberOfInstancesEffected(((Collection)result).size());
                } else {
                    profile.setNumberOfInstancesEffected(1L);
                }
                this.addProfile(profile);
                if (this.shouldLogProfile()) {
                    this.writeNestingTabs(writer);
                    long profileEndTime = System.nanoTime();
                    long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                    profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
                    profile.write(writer, this);
                    writer.write(Helper.cr());
                    this.writeNestingTabs(writer);
                    writer.write("}" + ToStringLocalization.buildMessage("end_profile", null));
                    writer.write(Helper.cr());
                    writer.flush();
                }
                if (this.getNestLevel() == 0) {
                    this.setNestTime(0L);
                    this.setProfileTime(0L);
                    this.setOperationTimings(new Hashtable<String, Long>());
                    this.setOperationStartTimes(new Hashtable<String, Long>());
                    long profileEndTime = System.nanoTime();
                    long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                    profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
                } else {
                    this.setNestTime(startNestTime + profile.getTotalTime());
                    this.setOperationTimings(timingsBeforeExecution);
                    this.setOperationStartTimes(startTimingsBeforeExecution);
                    long profileEndTime = System.nanoTime();
                    long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
                    this.setProfileTime(this.getProfileTime() + (totalTimeIncludingProfiling - (endTime - startTime)));
                    profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
                    for (String timingName : ((Map)((Hashtable)startTimingsBeforeExecution).clone()).keySet()) {
                        startTimingsBeforeExecution.put(timingName, ((Number)startTimingsBeforeExecution.get(timingName)).longValue() + totalTimeIncludingProfiling);
                    }
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return result;
            }
        }
        long endTime = System.nanoTime();
        this.setNestLevel(this.getNestLevel() - 1);
        for (String name : this.getOperationTimings().keySet()) {
            Long operationStartTime = (Long)timingsBeforeExecution.get(name);
            long operationEndTime = this.getOperationTimings().get(name);
            long operationTime = operationStartTime != null ? operationEndTime - operationStartTime : operationEndTime;
            profile.addTiming(name, operationTime);
        }
        profile.setTotalTime(endTime - startTime - (this.getProfileTime() - nestedProfileStartTime));
        profile.setLocalTime(profile.getTotalTime() - (this.getNestTime() - startNestTime));
        if (result instanceof Collection) {
            profile.setNumberOfInstancesEffected(((Collection)result).size());
        } else {
            profile.setNumberOfInstancesEffected(1L);
        }
        this.addProfile(profile);
        if (this.shouldLogProfile()) {
            this.writeNestingTabs(writer);
            long profileEndTime = System.nanoTime();
            long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
            profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
            profile.write(writer, this);
            writer.write(Helper.cr());
            this.writeNestingTabs(writer);
            writer.write("}" + ToStringLocalization.buildMessage("end_profile", null));
            writer.write(Helper.cr());
            writer.flush();
        }
        if (this.getNestLevel() == 0) {
            this.setNestTime(0L);
            this.setProfileTime(0L);
            this.setOperationTimings(new Hashtable<String, Long>());
            this.setOperationStartTimes(new Hashtable<String, Long>());
            long profileEndTime = System.nanoTime();
            long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
            profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
        } else {
            this.setNestTime(startNestTime + profile.getTotalTime());
            this.setOperationTimings(timingsBeforeExecution);
            this.setOperationStartTimes(startTimingsBeforeExecution);
            long profileEndTime = System.nanoTime();
            long totalTimeIncludingProfiling = profileEndTime - profileStartTime;
            this.setProfileTime(this.getProfileTime() + (totalTimeIncludingProfiling - (endTime - startTime)));
            profile.setProfileTime(totalTimeIncludingProfiling - profile.getTotalTime());
            for (String timingName : ((Map)((Hashtable)startTimingsBeforeExecution).clone()).keySet()) {
                startTimingsBeforeExecution.put(timingName, ((Number)startTimingsBeforeExecution.get(timingName)).longValue() + totalTimeIncludingProfiling);
            }
        }
        return object;
    }

    protected void setNestLevel(int nestLevel) {
        this.nestLevel = nestLevel;
    }

    protected void setNestTime(long nestTime) {
        this.nestTime = nestTime;
    }

    protected void setOperationStartTimes(Map<String, Long> operationStartTimes) {
        Integer threadId = Thread.currentThread().hashCode();
        this.getOperationStartTimesByThread().put(threadId, operationStartTimes);
    }

    protected void setOperationStartTimesByThread(Hashtable operationStartTimesByThread) {
        this.operationStartTimesByThread = operationStartTimesByThread;
    }

    protected void setOperationTimings(Map<String, Long> operationTimings) {
        Integer threadId = Thread.currentThread().hashCode();
        this.getOperationTimingsByThread().put(threadId, operationTimings);
    }

    protected void setOperationTimingsByThread(Hashtable operationTimingsByThread) {
        this.operationTimingsByThread = operationTimingsByThread;
    }

    protected void setProfiles(Vector profiles) {
        this.profiles = profiles;
    }

    protected void setProfileTime(long profileTime) {
        this.profileTime = profileTime;
    }

    @Override
    public void setSession(Session session) {
        this.session = (AbstractSession)session;
    }

    public void setShouldLogProfile(boolean shouldLogProfile) {
        this.shouldLogProfile = shouldLogProfile;
    }

    public boolean shouldLogProfile() {
        return this.shouldLogProfile;
    }

    @Override
    public void startOperationProfile(String operationName) {
        this.getOperationStartTimes().put(operationName, System.nanoTime());
    }

    @Override
    public void startOperationProfile(String operationName, DatabaseQuery query, int weight) {
        this.startOperationProfile(operationName);
    }

    protected void writeNestingTabs(Writer writer) {
        try {
            int index = 0;
            while (index < this.getNestLevel()) {
                writer.write("\t");
                ++index;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void update(String operationName, Object value) {
    }

    @Override
    public void occurred(String operationName) {
    }

    @Override
    public void occurred(String operationName, DatabaseQuery query) {
    }

    @Override
    public void setProfileWeight(int weight) {
    }

    @Override
    public int getProfileWeight() {
        return -1;
    }

    @Override
    public void initialize() {
    }
}

