/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class ReadObjectQuery
extends ObjectLevelReadQuery {
    protected transient Object selectionObject;
    protected Object selectionId;
    protected boolean shouldLoadResultIntoSelectionObject = false;

    public ReadObjectQuery() {
    }

    public ReadObjectQuery(Class classToRead) {
        this();
        this.referenceClass = classToRead;
    }

    public ReadObjectQuery(Class classToRead, Expression selectionCriteria) {
        this();
        this.referenceClass = classToRead;
        this.setSelectionCriteria(selectionCriteria);
    }

    public ReadObjectQuery(Class classToRead, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.referenceClass = classToRead;
    }

    public ReadObjectQuery(Class classToRead, Call call) {
        this();
        this.referenceClass = classToRead;
        this.setCall(call);
    }

    public ReadObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ReadObjectQuery(Object objectToRead) {
        this();
        this.setSelectionObject(objectToRead);
    }

    public ReadObjectQuery(Object exampleObject, QueryByExamplePolicy policy) {
        this();
        this.setExampleObject(exampleObject);
        this.setQueryByExamplePolicy(policy);
    }

    public ReadObjectQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public void cacheResult(Object object) {
        Object cachableObject = object;
        if (object == null) {
            this.temporaryCachedQueryResults = InvalidObject.instance();
        } else {
            if (this.shouldUseWrapperPolicy) {
                cachableObject = this.session.wrapObject(object);
            }
            this.temporaryCachedQueryResults = cachableObject;
        }
    }

    public void checkCacheByExactPrimaryKey() {
        this.setCacheUsage(1);
    }

    public void checkCacheByPrimaryKey() {
        this.setCacheUsage(2);
    }

    public void checkCacheThenDatabase() {
        this.setCacheUsage(3);
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.descriptor == null) {
            if (this.getReferenceClass() == null) {
                throw QueryException.referenceClassMissing(this);
            }
            ClassDescriptor referenceDescriptor = this.getSelectionObject() != null && session.getProject().hasProxyIndirection() ? session.getDescriptor(this.getSelectionObject()) : session.getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    protected Object checkEarlyReturnLocal(AbstractSession session, AbstractRecord translationRow) {
        if (!(!this.shouldCheckCache() || !this.shouldMaintainCache() || this.shouldRefreshIdentityMapResult() || this.shouldRetrieveBypassCache() || session.isRemoteSession() && (this.shouldRefreshRemoteIdentityMapResult() || this.descriptor.shouldDisableCacheHitsOnRemote()) || this.shouldCheckDescriptorForCacheUsage() && this.descriptor.shouldDisableCacheHits() || this.descriptor.isDescriptorForInterface())) {
            Object cachedObject = this.getQueryMechanism().checkCacheForObject(translationRow, session);
            if (cachedObject == InvalidObject.instance) {
                return cachedObject;
            }
            if (cachedObject != null) {
                if (this.shouldLoadResultIntoSelectionObject()) {
                    ObjectBuilder builder = this.descriptor.getObjectBuilder();
                    builder.copyInto(cachedObject, this.getSelectionObject());
                    session.getIdentityMapAccessorInstance().putInIdentityMap(this.getSelectionObject());
                    cachedObject = this.getSelectionObject();
                }
                if (this.isLockQuery() && session.isUnitOfWork() && !((UnitOfWorkImpl)session).isPessimisticLocked(cachedObject)) {
                    return null;
                }
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadObjectHits(this);
                }
                session.incrementProfile("Counter:CacheHits", this);
            } else if (!session.isUnitOfWork()) {
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadObjectMisses(this);
                }
                session.incrementProfile("Counter:CacheMisses", this);
            }
            if (this.shouldUseWrapperPolicy()) {
                cachedObject = this.descriptor.getObjectBuilder().wrapObject(cachedObject, session);
            }
            return cachedObject;
        }
        if (!session.isUnitOfWork()) {
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementReadObjectMisses(this);
            }
            session.incrementProfile("Counter:CacheMisses", this);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        if (this.descriptor == null) {
            this.checkDescriptor(session);
        }
        if (this.isCustomQueryUsed == null) {
            DescriptorQueryManager descriptorQueryManager;
            if (!(this.isUserDefined || this.isCallQuery() || !(descriptorQueryManager = this.descriptor.getQueryManager()).hasReadObjectQuery() || this.hasJoining() && this.joinedAttributeManager.hasJoinedAttributeExpressions() || this.hasPartialAttributeExpressions() || this.hasAsOfClause() || this.hasNonDefaultFetchGroup() || !this.wasDefaultLockMode || this.shouldBindAllParameters != null || this.hintString != null)) {
                if (this.selectionId != null || this.selectionObject != null) {
                    this.isCustomQueryUsed = true;
                } else {
                    AbstractRecord primaryKeyRow;
                    Expression selectionCriteria = this.getSelectionCriteria();
                    if (selectionCriteria != null && (primaryKeyRow = this.descriptor.getObjectBuilder().extractPrimaryKeyRowFromExpression(selectionCriteria, translationRow, session)) != null) {
                        this.isCustomQueryUsed = true;
                    }
                }
            }
            if (this.isCustomQueryUsed == null) {
                this.isCustomQueryUsed = false;
            }
        }
        if (this.isCustomQueryUsed.booleanValue()) {
            return this.descriptor.getQueryManager().getReadObjectQuery();
        }
        return null;
    }

    protected Object conformResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord databaseRow, boolean buildDirectlyFromRows) {
        Object clone = null;
        clone = buildDirectlyFromRows ? this.buildObject((AbstractRecord)result) : this.registerIndividualResult(this.descriptor.getObjectBuilder().unwrapObject(result, unitOfWork.getParent()), null, unitOfWork, null, null);
        Expression selectionCriteria = this.getSelectionCriteria();
        if (selectionCriteria != null && this.selectionId == null && this.selectionObject == null) {
            ExpressionBuilder builder = selectionCriteria.getBuilder();
            builder.setSession(unitOfWork.getRootSession(null));
            builder.setQueryClass(this.getReferenceClass());
        }
        if ((clone = this.conformIndividualResult(clone, unitOfWork, databaseRow, selectionCriteria, null)) == null) {
            return clone;
        }
        if (this.shouldUseWrapperPolicy()) {
            return this.descriptor.getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    public void dontLoadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(false);
    }

    public Object execute(AbstractSession session, AbstractRecord row) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared()) {
                Object result = this.getQueryResults(session, row, true);
                if (result == InvalidObject.instance) {
                    return null;
                }
                if (result != null) {
                    if (session.isUnitOfWork()) {
                        result = ((UnitOfWorkImpl)session).registerExistingObject(result);
                    }
                    return result;
                }
            }
        }
        return super.execute(session, row);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        if (this.descriptor.isDescriptorForInterface() || this.descriptor.hasTablePerClassPolicy()) {
            Object returnValue = this.descriptor.getInterfacePolicy().selectOneObjectUsingMultipleTableSubclassRead(this);
            if (!this.descriptor.hasTablePerClassPolicy() || this.descriptor.isAbstract() || returnValue != null) {
                this.executionTime = System.currentTimeMillis();
                return returnValue;
            }
        }
        AbstractRecord row = null;
        AbstractSession session = this.getSession();
        if (this.hasJoining() && this.getJoinedAttributeManager().isToManyJoin()) {
            Vector rows = this.getQueryMechanism().selectAllRows();
            if (rows.size() > 0) {
                row = (AbstractRecord)rows.get(0);
            }
            this.getJoinedAttributeManager().setDataResults(rows, session);
        } else {
            row = this.getQueryMechanism().selectOneRow();
        }
        this.executionTime = System.currentTimeMillis();
        Object result = null;
        if (row != null) {
            result = session.isUnitOfWork() ? this.registerResultInUnitOfWork(row, (UnitOfWorkImpl)session, this.translationRow, true) : this.buildObject(row);
        }
        if (result == null && this.shouldCacheQueryResults()) {
            this.cacheResult(null);
        }
        if (result == null && this.shouldRefreshIdentityMapResult) {
            if (this.selectionId != null) {
                session.getParentIdentityMapSession(this.descriptor, true, true).getIdentityMapAccessor().invalidateObject(this.selectionId, this.referenceClass);
            } else if (this.selectionObject != null) {
                session.getParentIdentityMapSession(this.descriptor, true, true).getIdentityMapAccessor().invalidateObject(this.selectionObject);
            }
        }
        if (this.shouldIncludeData) {
            ComplexQueryResult complexResult = new ComplexQueryResult();
            complexResult.setResult(result);
            complexResult.setData(row);
            return complexResult;
        }
        return result;
    }

    protected Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException {
        AbstractSession session = this.session;
        DatabasePlatform platform = session.getPlatform();
        DatabaseCall call = (DatabaseCall)((CallQueryMechanism)this.queryMechanism).getCall();
        call.returnCursor();
        call = this.queryMechanism.cursorSelectAllRows();
        Statement statement = call.getStatement();
        ResultSet resultSet = call.getResult();
        DatabaseAccessor accessor = (DatabaseAccessor)((List)this.accessors).get(0);
        boolean exceptionOccured = false;
        try {
            if (!resultSet.next()) {
                return null;
            }
            ResultSetMetaData metaData = resultSet.getMetaData();
            Object object = this.descriptor.getObjectBuilder().buildObjectFromResultSet(this, null, resultSet, session, accessor, metaData, platform);
            return object;
        }
        catch (SQLException exception) {
            exceptionOccured = true;
            DatabaseException commException = accessor.processExceptionForCommError(session, exception, call);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, call, accessor, session, false);
        }
        finally {
            block18: {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        accessor.releaseStatement(statement, call.getSQLString(), call, session);
                    }
                    if (accessor != null) {
                        session.releaseReadConnection(accessor);
                    }
                }
                catch (SQLException exception) {
                    if (exceptionOccured) break block18;
                    DatabaseException commException = accessor.processExceptionForCommError(session, exception, call);
                    if (commException != null) {
                        throw commException;
                    }
                    throw DatabaseException.sqlException(exception, call, accessor, session, false);
                }
            }
        }
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectCorrespondingTo(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashMap(), this);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReadObjectQueryRedirector();
    }

    @Deprecated
    public Vector getSelectionKey() {
        if (this.selectionId instanceof CacheId) {
            return new Vector<Object>(Arrays.asList(((CacheId)this.selectionId).getPrimaryKey()));
        }
        Vector<Object> primaryKey = new Vector<Object>(1);
        primaryKey.add(this.selectionId);
        return (Vector)this.selectionId;
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public boolean isReadObjectQuery() {
        return true;
    }

    public boolean isPrimaryKeyQuery() {
        return this.selectionId != null || this.selectionObject != null;
    }

    public void loadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(true);
    }

    public void copyFromQuery(DatabaseQuery query) {
        super.copyFromQuery(query);
        if (query.isReadObjectQuery()) {
            ReadObjectQuery readQuery = (ReadObjectQuery)query;
            this.selectionId = readQuery.selectionId;
            this.selectionObject = readQuery.selectionObject;
            this.shouldLoadResultIntoSelectionObject = readQuery.shouldLoadResultIntoSelectionObject;
        }
    }

    protected void prepare() throws QueryException {
        Expression selectionCriteria;
        if (this.prepareFromCachedQuery()) {
            return;
        }
        super.prepare();
        if (this.selectionId != null || this.selectionObject != null) {
            this.setSelectionCriteria(this.descriptor.getObjectBuilder().getPrimaryKeyExpression());
            this.setExpressionBuilder(this.getSelectionCriteria().getBuilder());
            this.extendPessimisticLockScope();
            if (!this.shouldPrepare()) {
                if (this.selectionId != null) {
                    this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(this.selectionId, this.session));
                } else {
                    this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowForTranslation(this.selectionObject, this.session));
                }
            }
        }
        if (this.descriptor.isDescriptorForInterface()) {
            return;
        }
        if (this.isExpressionQuery() && (selectionCriteria = this.getSelectionCriteria()) != null && (this.cacheUsage == 2 && !this.descriptor.getObjectBuilder().isPrimaryKeyExpression(false, selectionCriteria, this.session) || this.cacheUsage == 1 && !this.descriptor.getObjectBuilder().isPrimaryKeyExpression(true, selectionCriteria, this.session))) {
            this.cacheUsage = 0;
        }
        if (this.joinedAttributeManager != null && this.joinedAttributeManager.isToManyJoin()) {
            this.getQueryMechanism().prepareSelectAllRows();
        } else {
            this.getQueryMechanism().prepareSelectOneRow();
        }
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ReadObjectQuery customReadQuery = (ReadObjectQuery)customQuery;
        customReadQuery.shouldRefreshIdentityMapResult = this.shouldRefreshIdentityMapResult;
        customReadQuery.cascadePolicy = this.cascadePolicy;
        customReadQuery.shouldMaintainCache = this.shouldMaintainCache;
        customReadQuery.shouldUseWrapperPolicy = this.shouldUseWrapperPolicy;
        customReadQuery.queryId = this.queryId;
        customReadQuery.executionTime = this.executionTime;
        customReadQuery.shouldLoadResultIntoSelectionObject = this.shouldLoadResultIntoSelectionObject;
        if (this.selectionObject != null) {
            customReadQuery.selectionObject = this.selectionObject;
        } else if (this.selectionId != null) {
            customReadQuery.selectionId = this.selectionId;
        } else {
            AbstractRecord primaryKeyRow = customQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), customQuery.getTranslationRow(), customReadQuery.getSession());
            customReadQuery.setTranslationRow(primaryKeyRow);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.shouldPrepare()) {
            if (this.selectionId != null) {
                this.translationRow = this.descriptor.getObjectBuilder().buildRowFromPrimaryKeyValues(this.selectionId, this.getSession());
            } else if (this.selectionObject != null) {
                this.translationRow = this.descriptor.getObjectBuilder().buildRowForTranslation(this.selectionObject, this.getSession());
            }
        }
        if (this.getDescriptor().hasMultitenantPolicy()) {
            this.getDescriptor().getMultitenantPolicy().addFieldsToRow(this.getTranslationRow(), this.getSession());
        }
    }

    protected void prePrepare() throws QueryException {
        super.prePrepare();
        if (this.getSelectionObject() != null && this.getSession().getProject().hasProxyIndirection()) {
            this.setSelectionObject(ProxyIndirectionPolicy.getValueFromProxy(this.getSelectionObject()));
        }
    }

    public Object registerResultInUnitOfWork(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        if (result == null) {
            return null;
        }
        if (unitOfWork.hasCloneMapping() && (this.shouldConformResultsInUnitOfWork() || this.descriptor.shouldAlwaysConformResultsInUnitOfWork())) {
            return this.conformResult(result, unitOfWork, arguments, buildDirectlyFromRows);
        }
        Object clone = null;
        clone = buildDirectlyFromRows ? this.buildObject((AbstractRecord)result) : this.registerIndividualResult(result, null, unitOfWork, null, null);
        if (this.shouldUseWrapperPolicy()) {
            clone = this.descriptor.getObjectBuilder().wrapObject(clone, unitOfWork);
        }
        return clone;
    }

    protected Object remoteExecute() {
        Object cacheHit;
        this.checkDescriptor(this.session);
        if (this.getSelectionObject() != null) {
            this.setSelectionId(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getSelectionObject(), this.session));
        }
        if ((cacheHit = this.checkEarlyReturn(this.getSession(), this.getTranslationRow())) != null || this.shouldCheckCacheOnly()) {
            return cacheHit;
        }
        return super.remoteExecute();
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return controller.replaceValueHoldersIn(object);
    }

    protected Object getQueryPrimaryKey() {
        return this.getSelectionId();
    }

    public Object getSelectionId() {
        return this.selectionId;
    }

    public void setSelectionId(Object id) {
        this.selectionId = id;
    }

    @Deprecated
    public void setSelectionKey(List selectionKey) {
        this.selectionId = selectionKey == null ? null : (selectionKey.size() == 1 ? selectionKey.get(0) : new CacheId(selectionKey.toArray()));
    }

    public void setSelectionObject(Object selectionObject) {
        if (selectionObject == null) {
            throw QueryException.selectionObjectCannotBeNull(this);
        }
        this.setSelectionId(null);
        if (this.selectionObject == null || this.selectionObject.getClass() != selectionObject.getClass()) {
            this.setIsPrepared(false);
        }
        this.setReferenceClass(selectionObject.getClass());
        this.selectionObject = selectionObject;
    }

    public void setShouldLoadResultIntoSelectionObject(boolean shouldLoadResultIntoSelectionObject) {
        this.shouldLoadResultIntoSelectionObject = shouldLoadResultIntoSelectionObject;
    }

    @Deprecated
    public void setSingletonSelectionKey(Object selectionKey) {
        NonSynchronizedVector key = new NonSynchronizedVector();
        ((Vector)key).add(selectionKey);
        this.setSelectionKey(key);
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.cacheUsage == 1;
    }

    public boolean shouldCheckCacheByPrimaryKey() {
        return this.cacheUsage == 2 || this.cacheUsage == -1;
    }

    public boolean shouldCheckCacheThenDatabase() {
        return this.cacheUsage == 3;
    }

    public boolean shouldLoadResultIntoSelectionObject() {
        return this.shouldLoadResultIntoSelectionObject;
    }

    protected boolean hasNonDefaultFetchGroup() {
        return this.descriptor.hasFetchGroupManager() && (this.fetchGroup != null || this.fetchGroupName != null || !this.shouldUseDefaultFetchGroup && this.descriptor.getFetchGroupManager().getDefaultFetchGroup() != null);
    }
}

