/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IsolatedClientSessionIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class IsolatedClientSession
extends ClientSession {
    public IsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        super(parent, connectionPolicy);
        this.shouldCheckWriteLock = this.getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getDatasourceLogin().shouldSynchronizeWrites();
    }

    public IsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        super(parent, connectionPolicy, properties);
        this.shouldCheckWriteLock = this.getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getDatasourceLogin().shouldSynchronizeWrites();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new IsolatedClientSessionIdentityMapAccessor(this);
    }

    protected boolean shouldExecuteLocally(DatabaseQuery query) {
        if (this.isIsolatedQuery(query)) {
            return true;
        }
        return this.isInTransaction();
    }

    protected boolean isIsolatedQuery(DatabaseQuery query) {
        query.checkDescriptor(this);
        ClassDescriptor descriptor = query.getDescriptor();
        return query.isDataModifyQuery() || query.isDataReadQuery() || descriptor != null && descriptor.getCachePolicy().isIsolated() || query.isObjectBuildingQuery() && ((ObjectBuildingQuery)query).shouldUseExclusiveConnection();
    }

    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        if (canReturnSelf && (descriptor == null || descriptor.getCachePolicy().isIsolated() || descriptor.getCachePolicy().isProtectedIsolation() && !descriptor.shouldIsolateProtectedObjectsInUnitOfWork() && !terminalOnly)) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(descriptor, canReturnSelf, terminalOnly);
    }

    protected CacheKey getCacheKeyFromTargetSessionForMerge(Object implementation, ObjectBuilder builder, ClassDescriptor descriptor, MergeManager mergeManager) {
        Object primaryKey = builder.extractPrimaryKeyFromObject(implementation, this, true);
        CacheKey cacheKey = this.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, implementation.getClass(), descriptor, true);
        return cacheKey;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.shouldExecuteLocally(query)) {
            return this;
        }
        return this.parent.getExecutionSession(query);
    }

    public boolean isIsolatedClientSession() {
        return true;
    }

    public boolean isProtectedSession() {
        return true;
    }
}

