/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class MapKeyNode
extends Node
implements AliasableNode {
    public boolean isMapKeyNode() {
        return true;
    }

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = this.generateExpression(generationContext);
            reportQuery.addItem(String.valueOf(this.left.resolveAttribute()) + "MapKey", expression);
        }
    }

    public Expression generateExpression(GenerationContext context) {
        Expression owningExpression = this.getLeft().generateExpression(context);
        MapEntryExpression whereClause = new MapEntryExpression(owningExpression);
        return whereClause;
    }

    public Node getLeftMostNode() {
        if (this.left.isDotNode()) {
            return ((DotNode)this.left).getLeftMostNode();
        }
        return this.left;
    }

    public void validate(ParseTreeContext context) {
        this.left.validate(context);
        if (this.left.isVariableNode()) {
            this.setType(((VariableNode)this.left).getTypeForMapKey(context));
        } else if (this.left.isDotNode()) {
            this.setType(((DotNode)this.left).getTypeForMapKey(context));
        }
    }

    public boolean isAliasableNode() {
        return true;
    }
}

