/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.DirectColumnMetadata;

public class ColumnMetadata
extends DirectColumnMetadata {
    private Boolean m_unique;
    private Integer m_scale;
    private Integer m_length;
    private Integer m_precision;
    private String m_table;

    public ColumnMetadata() {
        super("<column>");
    }

    public ColumnMetadata(MetadataAccessor accessor) {
        this(null, accessor);
    }

    public ColumnMetadata(MetadataAnnotation column, MetadataAccessor accessor) {
        super(column, accessor);
        if (column != null) {
            this.setUnique((Boolean)column.getAttribute("unique"));
            this.setNullable((Boolean)column.getAttribute("nullable"));
            this.setUpdatable((Boolean)column.getAttribute("updatable"));
            this.setInsertable((Boolean)column.getAttribute("insertable"));
            this.setScale((Integer)column.getAttribute("scale"));
            this.setLength((Integer)column.getAttribute("length"));
            this.setPrecision((Integer)column.getAttribute("precision"));
            this.setName((String)column.getAttributeString("name"));
            this.setTable((String)column.getAttributeString("table"));
            this.setColumnDefinition((String)column.getAttributeString("columnDefinition"));
        }
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ColumnMetadata) {
            ColumnMetadata column = (ColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_unique, column.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_scale, column.getScale())) {
                return false;
            }
            if (!this.valuesMatch(this.m_length, column.getLength())) {
                return false;
            }
            if (!this.valuesMatch(this.m_precision, column.getPrecision())) {
                return false;
            }
            return this.valuesMatch(this.m_table, column.getTable());
        }
        return false;
    }

    public DatabaseField getDatabaseField() {
        DatabaseField field = super.getDatabaseField();
        field.setUnique(this.m_unique == null ? false : this.m_unique);
        field.setScale(this.m_scale == null ? 0 : this.m_scale);
        field.setLength(this.m_length == null ? 0 : this.m_length);
        field.setPrecision(this.m_precision == null ? 0 : this.m_precision);
        field.setTableName(this.m_table == null ? "" : this.m_table);
        return field;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }
}

